/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.world;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.elementfactory.ContentElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.DateFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.LabelElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.NumberFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.GroupDataBodyType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.function.ItemSumFunction;
import org.pentaho.reporting.engine.classic.core.function.RowBandingFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.world.CountryDataTableModel;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CountryReportAPIDemoHandler
extends AbstractDemoHandler {
    private CountryDataTableModel data = new CountryDataTableModel();

    @Override
    public String getDemoName() {
        return "Country Report Demo (API)";
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"country-report-api.html", CountryReportAPIDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    private PageHeader createPageHeader() {
        PageHeader header = new PageHeader();
        header.setName("Page-header");
        header.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(18.0f));
        header.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Dialog");
        header.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, (Object)new Color(0xAFAFAF));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, (Object)new Color(0xAFAFAF));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, (Object)new Color(0xAFAFAF));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, (Object)new Color(0xAFAFAF));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, (Object)new Float(1.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, (Object)new Float(1.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, (Object)new Float(1.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, (Object)new Float(1.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, (Object)BorderStyle.SOLID);
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, (Object)BorderStyle.SOLID);
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, (Object)BorderStyle.SOLID);
        header.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, (Object)BorderStyle.SOLID);
        header.setDisplayOnFirstPage(true);
        header.setDisplayOnLastPage(false);
        DateFieldElementFactory factory = new DateFieldElementFactory();
        factory.setName("Date");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 14.0f));
        factory.setHorizontalAlignment(ElementAlignment.RIGHT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("<null>");
        factory.setFormatString("d-MMM-yyyy");
        factory.setFieldname("report.date");
        header.addElement(factory.createElement());
        Element line = HorizontalLineElementFactory.createHorizontalLine((float)16.0f);
        line.getStyle().setStyleProperty(ElementStyleKeys.STROKE, (Object)new BasicStroke(2.0f));
        line.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)Color.decode("#CFCFCF"));
        header.addElement(line);
        return header;
    }

    private PageFooter createPageFooter() {
        PageFooter pageFooter = new PageFooter();
        pageFooter.setName("Page-Footer");
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(30.0f));
        pageFooter.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Dialog");
        pageFooter.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, (Object)new Float(1.0f));
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, (Object)new Float(1.0f));
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, (Object)new Float(1.0f));
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, (Object)new Float(1.0f));
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, (Object)BorderStyle.SOLID);
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, (Object)BorderStyle.SOLID);
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, (Object)BorderStyle.SOLID);
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, (Object)BorderStyle.SOLID);
        LabelElementFactory factory = new LabelElementFactory();
        factory.setName("Page-Footer-Label");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 0.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.TOP);
        factory.setText("Some Text for the page footer");
        factory.setDynamicHeight(Boolean.TRUE);
        pageFooter.addElement(factory.createElement());
        return pageFooter;
    }

    private ReportFooter createReportFooter() {
        ReportFooter footer = new ReportFooter();
        footer.setName("Report-Footer");
        footer.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(48.0f));
        footer.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Serif");
        footer.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(16));
        footer.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.TRUE);
        LabelElementFactory factory = new LabelElementFactory();
        factory.setName("Report-Footer-Label");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 24.0f));
        factory.setHorizontalAlignment(ElementAlignment.CENTER);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setText("*** END OF REPORT ***");
        footer.addElement(factory.createElement());
        return footer;
    }

    private ReportHeader createReportHeader() {
        ReportHeader header = new ReportHeader();
        header.setName("Report-Header");
        header.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(48.0f));
        header.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Serif");
        header.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(20));
        header.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.TRUE);
        LabelElementFactory factory = new LabelElementFactory();
        factory.setName("Report-Header-Label");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 24.0f));
        factory.setHorizontalAlignment(ElementAlignment.CENTER);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setText("LIST OF CONTINENTS BY COUNTRY");
        header.addElement(factory.createElement());
        return header;
    }

    private ItemBand createItemBand() {
        ItemBand items = new ItemBand();
        items.setName("Items");
        items.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(10.0f));
        items.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Monospaced");
        items.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        items.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)Color.decode("#dfdfdf"));
        items.addElement(HorizontalLineElementFactory.createHorizontalLine((float)0.0f, (Color)Color.decode("#DFDFDF"), (Stroke)new BasicStroke(0.1f)));
        items.addElement(HorizontalLineElementFactory.createHorizontalLine((float)10.0f, (Color)Color.decode("#DFDFDF"), (Stroke)new BasicStroke(0.1f)));
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setName("Country Element");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(176.0f, 10.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("<null>");
        factory.setFieldname("Country");
        items.addElement(factory.createElement());
        factory = new TextFieldElementFactory();
        factory.setName("Code Element");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(180.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(76.0f, 10.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("<null>");
        factory.setFieldname("ISO Code");
        items.addElement(factory.createElement());
        NumberFieldElementFactory nfactory = new NumberFieldElementFactory();
        nfactory.setName("Population Element");
        nfactory.setAbsolutePosition((Point2D)new Point2D.Float(260.0f, 0.0f));
        nfactory.setMinimumSize((Dimension2D)new FloatDimension(76.0f, 10.0f));
        nfactory.setHorizontalAlignment(ElementAlignment.LEFT);
        nfactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        nfactory.setNullString("<null>");
        nfactory.setFieldname("Population");
        nfactory.setFormatString("#,##0");
        items.addElement(nfactory.createElement());
        return items;
    }

    private ExpressionCollection createFunctions() {
        ExpressionCollection functions = new ExpressionCollection();
        ItemSumFunction sum = new ItemSumFunction();
        sum.setName("sum");
        sum.setField("Population");
        sum.setGroup("Continent Group");
        functions.add((Expression)sum);
        RowBandingFunction backgroundTrigger = new RowBandingFunction();
        backgroundTrigger.setName("backgroundTrigger");
        functions.add((Expression)backgroundTrigger);
        return functions;
    }

    private RelationalGroup createContinentGroup() {
        RelationalGroup continentGroup = new RelationalGroup();
        continentGroup.setName("Continent Group");
        continentGroup.addField("Continent");
        GroupHeader header = new GroupHeader();
        header.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Monospaced");
        header.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        header.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.TRUE);
        header.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(20.0f));
        header.setName("Continent-Group-Header");
        LabelElementFactory factory = new LabelElementFactory();
        factory.setName("Continent-Group-Header-Label");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 1.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(76.0f, 9.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setText("CONTINENT:");
        header.addElement(factory.createElement());
        TextFieldElementFactory tfactory = new TextFieldElementFactory();
        tfactory.setName("Continent-Group-Header Continent Element");
        tfactory.setAbsolutePosition((Point2D)new Point2D.Float(96.0f, 1.0f));
        tfactory.setMinimumSize((Dimension2D)new FloatDimension(76.0f, 9.0f));
        tfactory.setHorizontalAlignment(ElementAlignment.LEFT);
        tfactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        tfactory.setNullString("<null>");
        tfactory.setFieldname("Continent");
        header.addElement(tfactory.createElement());
        header.addElement(HorizontalLineElementFactory.createHorizontalLine((float)12.0f, null, (Stroke)new BasicStroke(0.5f)));
        continentGroup.setHeader(header);
        GroupFooter footer = new GroupFooter();
        footer.setName("Continent-Group-Footer");
        footer.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(20.0f));
        header.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"Monospaced");
        header.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        header.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.TRUE);
        factory = new LabelElementFactory();
        factory.setName("Continent-Group-Footer Label");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(100.0f, 12.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setText("Population:");
        footer.addElement(factory.createElement());
        NumberFieldElementFactory nfactory = new NumberFieldElementFactory();
        nfactory.setName("Continent-Group-Footer Sum");
        nfactory.setAbsolutePosition((Point2D)new Point2D.Float(260.0f, 0.0f));
        nfactory.setMinimumSize((Dimension2D)new FloatDimension(76.0f, 12.0f));
        nfactory.setHorizontalAlignment(ElementAlignment.LEFT);
        nfactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        nfactory.setNullString("<null>");
        nfactory.setFieldname("sum");
        nfactory.setFormatString("#,##0");
        footer.addElement(nfactory.createElement());
        continentGroup.setFooter(footer);
        return continentGroup;
    }

    @Override
    public MasterReport createReport() {
        MasterReport report = new MasterReport();
        report.setName("Sample Report 1");
        report.setReportFooter(this.createReportFooter());
        report.setReportHeader(this.createReportHeader());
        report.setPageFooter(this.createPageFooter());
        report.setPageHeader(this.createPageHeader());
        report.addGroup(this.createContinentGroup());
        GroupDataBody dataBody = (GroupDataBody)report.getChildElementByType((ElementType)GroupDataBodyType.INSTANCE);
        dataBody.setItemBand(this.createItemBand());
        report.setExpressions(this.createFunctions());
        report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.Encoding", "Identity-H");
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)this.data));
        try {
            Watermark watermark = report.getWatermark();
            watermark.setName("WaterMark");
            URL resource = this.getClass().getResource("earth.png");
            ContentElementFactory img1 = new ContentElementFactory();
            img1.setContent((Object)resource);
            img1.setMinimumSize((Dimension2D)new FloatDimension(500.0f, 500.0f));
            img1.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
            img1.setScale(Boolean.TRUE);
            watermark.addElement(img1.createElement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return report;
    }
}

