/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.elements.sparklines;

import java.awt.Window;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.demo.elements.sparklines.SparklineXMLDemo;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SparklineODFDemo
extends AbstractXmlDemoHandler {
    private TableModel data = this.createData();

    private TableModel createData() {
        try {
            MasterReport report = this.createReport();
            return report.getDataFactory().queryData(report.getQuery(), (DataRow)report.getParameterValues());
        }
        catch (Exception e) {
            Object[] columnNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
            return new DefaultTableModel(columnNames, 0);
        }
    }

    @Override
    public String getDemoName() {
        return "Sparkline bar-graph demo (Unified File Format)";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        return this.parseReport();
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"sparkline-simple.html", SparklineXMLDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"sparklines.prpt", SparklineODFDemo.class);
    }

    public static void main(String[] args) throws Exception {
        ClassicEngineBoot.getInstance().start();
        SparklineODFDemo demoHandler = new SparklineODFDemo();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

