/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.util;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.about.AboutDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.DefaultIconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.engine.classic.demo.ClassicEngineDemoInfo;
import org.pentaho.reporting.engine.classic.demo.util.DemoController;
import org.pentaho.reporting.engine.classic.demo.util.NumberCellRenderer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public abstract class AbstractDemoFrame
extends JFrame
implements DemoController {
    public static final String EMBEDDED_KEY = "org.pentaho.reporting.engine.classic.demo.Embedded";
    public static final String RESOURCE_BASE = "org.pentaho.reporting.engine.classic.demo.resources.demo-resources";
    private ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.demo.resources.demo-resources", ObjectUtilities.getClassLoader(AbstractDemoFrame.class));
    private Action closeAction;
    private Action previewAction = new PreviewAction();
    private AboutAction aboutAction;
    private AboutDialog aboutFrame;
    private boolean ignoreEmbeddedConfig;
    private JStatusBar statusBar;

    public AbstractDemoFrame() {
        this.closeAction = new CloseAction();
        this.aboutAction = new AboutAction();
        this.statusBar = new JStatusBar();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseHandler());
    }

    public boolean isIgnoreEmbeddedConfig() {
        return this.ignoreEmbeddedConfig;
    }

    public void setIgnoreEmbeddedConfig(boolean ignoreEmbeddedConfig) {
        this.ignoreEmbeddedConfig = ignoreEmbeddedConfig;
    }

    public ResourceBundleSupport getResources() {
        return this.resources;
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public Action getPreviewAction() {
        return this.previewAction;
    }

    public AboutAction getAboutAction() {
        return this.aboutAction;
    }

    protected boolean attemptExit() {
        boolean close;
        boolean bl = close = JOptionPane.showConfirmDialog(this, this.getResources().getString("exitdialog.message"), this.getResources().getString("exitdialog.title"), 0, 3) == 0;
        if (close) {
            if (this.ignoreEmbeddedConfig || "false".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(EMBEDDED_KEY, "false"))) {
                System.exit(0);
            } else {
                this.setVisible(false);
                this.dispose();
            }
        }
        return close;
    }

    protected abstract void attemptPreview();

    protected JMenu createJMenu(String base) {
        String label = this.getResources().getString(base + ".name");
        Integer mnemonic = this.getResources().getMnemonic(base + ".mnemonic");
        JMenu menu = new JMenu(label);
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic);
        }
        return menu;
    }

    public static void showExceptionDialog(Component parent, String localisationBase, Exception e) {
        ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), RESOURCE_BASE, ObjectUtilities.getClassLoader(AbstractDemoFrame.class));
        String title = resources.getString(localisationBase + ".title");
        String format = resources.getString(localisationBase + ".message");
        String message = MessageFormat.format(format, e.getLocalizedMessage());
        ExceptionDialog.showExceptionDialog((Component)parent, (String)title, (String)message, (Exception)e);
    }

    protected JComponent createDefaultTable(TableModel data) {
        JTable table = new JTable(data);
        table.setAutoResizeMode(0);
        for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            column.setMinWidth(50);
            Class<?> c = data.getColumnClass(columnIndex);
            if (!c.equals(Number.class)) continue;
            column.setCellRenderer(new NumberCellRenderer());
        }
        return new JScrollPane(table, 20, 32);
    }

    public synchronized void displayAbout() {
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutDialog(this.getResources().getString("action.about.name"), ClassicEngineDemoInfo.getInstance());
            this.aboutFrame.pack();
            LibSwingUtil.centerFrameOnScreen((Window)this.aboutFrame);
        }
        this.aboutFrame.setVisible(true);
        this.aboutFrame.requestFocus();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = this.createJMenu("menu.file");
        JMenuItem previewItem = new JMenuItem(this.getPreviewAction());
        JMenuItem exitItem = new JMenuItem(this.getCloseAction());
        fileMenu.add(previewItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        mb.add(fileMenu);
        JMenu helpMenu = this.createJMenu("menu.help");
        helpMenu.add(new JMenuItem(this.aboutAction));
        mb.add(helpMenu);
        return mb;
    }

    @Override
    public Action getExportAction() {
        return this.previewAction;
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            DefaultIconTheme iconTheme = new DefaultIconTheme();
            this.putValue("Name", AbstractDemoFrame.this.resources.getString("action.about.name"));
            this.putValue("ShortDescription", AbstractDemoFrame.this.resources.getString("action.about.description"));
            this.putValue("MnemonicKey", AbstractDemoFrame.this.resources.getMnemonic("action.about.mnemonic"));
            this.putValue("SmallIcon", iconTheme.getSmallIcon(Locale.getDefault(), "action.about.small-icon"));
            this.putValue("ICON24", iconTheme.getLargeIcon(Locale.getDefault(), "action.about.icon"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractDemoFrame.this.displayAbout();
        }
    }

    protected class PreviewAction
    extends AbstractAction {
        public PreviewAction() {
            this.putValue("Name", AbstractDemoFrame.this.resources.getString("action.print-preview.name"));
            this.putValue("ShortDescription", AbstractDemoFrame.this.resources.getString("action.print-preview.description"));
            this.putValue("MnemonicKey", AbstractDemoFrame.this.resources.getMnemonic("action.print-preview.mnemonic"));
            this.putValue("SmallIcon", ImageUtils.createTransparentIcon((int)16, (int)16));
            this.putValue("AcceleratorKey", AbstractDemoFrame.this.resources.getKeyStroke("action.print-preview.accelerator"));
            this.putValue("ICON24", ImageUtils.createTransparentIcon((int)24, (int)24));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractDemoFrame.this.attemptPreview();
        }
    }

    protected class CloseHandler
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            AbstractDemoFrame.this.attemptExit();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", AbstractDemoFrame.this.resources.getString("action.close.name"));
            this.putValue("ShortDescription", AbstractDemoFrame.this.resources.getString("action.close.description"));
            this.putValue("MnemonicKey", AbstractDemoFrame.this.resources.getMnemonic("action.close.mnemonic"));
            this.putValue("SmallIcon", ImageUtils.createTransparentIcon((int)16, (int)16));
            this.putValue("AcceleratorKey", AbstractDemoFrame.this.resources.getKeyStroke("action.close.accelerator"));
            this.putValue("ICON24", ImageUtils.createTransparentIcon((int)24, (int)24));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractDemoFrame.this.attemptExit();
        }
    }
}

