/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoFrame;
import org.pentaho.reporting.engine.classic.demo.util.DemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.DemoHandlerTreeNode;
import org.pentaho.reporting.engine.classic.demo.util.DemoSelector;
import org.pentaho.reporting.engine.classic.demo.util.DemoSelectorTreeNode;
import org.pentaho.reporting.engine.classic.demo.util.InternalDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CompoundDemoFrame
extends AbstractDemoFrame {
    private static final Log logger = LogFactory.getLog(CompoundDemoFrame.class);
    private DemoHandler selectedHandler;
    private DemoSelector demoSelector;
    private JPanel demoContent;
    private JComponent externalHandlerArea;

    public CompoundDemoFrame(DemoSelector demoSelector) {
        this.demoSelector = demoSelector;
    }

    public DemoSelector getDemoSelector() {
        return this.demoSelector;
    }

    protected void init() {
        this.setTitle(this.demoSelector.getName());
        this.setJMenuBar(this.createMenuBar());
        this.setContentPane(this.createDefaultContentPane());
    }

    protected void setSelectedHandler(DemoHandler handler) {
        this.selectedHandler = handler;
        this.demoContent.removeAll();
        if (handler instanceof InternalDemoHandler) {
            this.demoContent.add(this.createDefaultDemoPane((InternalDemoHandler)handler));
            this.getPreviewAction().setEnabled(true);
        } else if (handler != null) {
            this.demoContent.add(this.getExternalHandlerInfoPane());
            this.getPreviewAction().setEnabled(true);
        } else {
            this.demoContent.add(this.getNoHandlerInfoPane());
            this.getPreviewAction().setEnabled(false);
        }
        this.demoContent.revalidate();
    }

    protected JComponent getExternalHandlerInfoPane() {
        if (this.externalHandlerArea == null) {
            JPanel content = new JPanel(new BorderLayout());
            content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            URL url = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/resources/external-handler-info.html", CompoundDemoFrame.class);
            JComponent scroll = this.createDescriptionTextPane(url);
            JButton previewButton = new JButton(this.getPreviewAction());
            content.add((Component)scroll, "Center");
            content.add((Component)previewButton, "South");
            this.externalHandlerArea = content;
        }
        return this.externalHandlerArea;
    }

    protected JComponent createDescriptionTextPane(URL url) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setPreferredSize(new Dimension(400, 200));
        if (url != null) {
            try {
                editorPane.setPage(url);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to load demo description", (Throwable)e);
                editorPane.setText("Unable to load the demo description. Error: " + e.getMessage());
            }
        } else {
            editorPane.setText("Unable to load the demo description. No such resource.");
        }
        return new JScrollPane(editorPane, 20, 30);
    }

    protected JComponent getNoHandlerInfoPane() {
        return new JPanel();
    }

    public DemoHandler getSelectedHandler() {
        return this.selectedHandler;
    }

    protected Container createDefaultContentPane() {
        this.demoContent = new JPanel();
        this.demoContent.setLayout(new BorderLayout());
        this.demoContent.setMinimumSize(new Dimension(100, 100));
        this.demoContent.add((Component)this.getNoHandlerInfoPane(), "Center");
        JPanel placeHolder = new JPanel();
        placeHolder.setMinimumSize(new Dimension(300, 0));
        placeHolder.setPreferredSize(new Dimension(300, 0));
        placeHolder.setMaximumSize(new Dimension(300, 0));
        JPanel rootContent = new JPanel();
        rootContent.setLayout(new BorderLayout());
        rootContent.add((Component)this.demoContent, "Center");
        rootContent.add((Component)placeHolder, "North");
        DemoSelectorTreeNode root = new DemoSelectorTreeNode(null, this.demoSelector);
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree demoTree = new JTree(model);
        demoTree.addTreeSelectionListener(new TreeSelectionHandler());
        JSplitPane rootSplitPane = new JSplitPane(1, new JScrollPane(demoTree), rootContent);
        rootSplitPane.setContinuousLayout(true);
        rootSplitPane.setDividerLocation(200);
        rootSplitPane.setOneTouchExpandable(true);
        return rootSplitPane;
    }

    protected JComponent createDefaultDemoPane(InternalDemoHandler demoHandler) {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        URL url = demoHandler.getDemoDescriptionSource();
        JComponent scroll = this.createDescriptionTextPane(url);
        JButton previewButton = new JButton(this.getPreviewAction());
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(scroll);
        splitPane.setBottomComponent(demoHandler.getPresentationComponent());
        splitPane.setDividerLocation(200);
        splitPane.setOneTouchExpandable(true);
        content.add((Component)splitPane, "Center");
        content.add((Component)previewButton, "South");
        return content;
    }

    @Override
    protected void attemptPreview() {
        DemoHandler selectedHandler = this.getSelectedHandler();
        if (selectedHandler == null) {
            return;
        }
        PreviewHandler previewHandler = selectedHandler.getPreviewHandler();
        previewHandler.attemptPreview();
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath treePath = e.getNewLeadSelectionPath();
            if (treePath == null) {
                CompoundDemoFrame.this.setSelectedHandler(null);
            } else {
                Object o = treePath.getLastPathComponent();
                if (o instanceof DemoHandlerTreeNode) {
                    DemoHandlerTreeNode handlerNode = (DemoHandlerTreeNode)o;
                    DemoHandler handler = handlerNode.getHandler();
                    CompoundDemoFrame.this.setSelectedHandler(handler);
                } else {
                    CompoundDemoFrame.this.setSelectedHandler(null);
                }
            }
        }
    }
}

