/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.util;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.pentaho.reporting.engine.classic.demo.util.ArrayEnumeration;
import org.pentaho.reporting.engine.classic.demo.util.DemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.DemoHandlerTreeNode;
import org.pentaho.reporting.engine.classic.demo.util.DemoSelector;

public class DemoSelectorTreeNode
implements TreeNode {
    private TreeNode parent;
    private DemoSelector selector;
    private TreeNode[] childs;

    public DemoSelectorTreeNode(TreeNode parent, DemoSelector selector) {
        this.parent = parent;
        this.selector = selector;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        DemoSelector[] selectors = selector.getChilds();
        for (int i = 0; i < selectors.length; ++i) {
            DemoSelector demoSelector = selectors[i];
            nodes.add(new DemoSelectorTreeNode(this, demoSelector));
        }
        DemoHandler[] handlers = selector.getDemos();
        for (int i = 0; i < handlers.length; ++i) {
            DemoHandler handler = handlers[i];
            nodes.add(new DemoHandlerTreeNode(this, handler));
        }
        this.childs = nodes.toArray(new TreeNode[nodes.size()]);
    }

    public DemoSelector getSelector() {
        return this.selector;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.childs[childIndex];
    }

    @Override
    public int getChildCount() {
        return this.childs.length;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.childs.length; ++i) {
            TreeNode child = this.childs[i];
            if (node != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new ArrayEnumeration(this.childs);
    }

    public String toString() {
        return this.selector.getName();
    }
}

