/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoFrame;
import org.pentaho.reporting.engine.classic.demo.util.InternalDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;

public class SimpleDemoFrame
extends AbstractDemoFrame {
    private InternalDemoHandler demoHandler;

    public SimpleDemoFrame(InternalDemoHandler demoHandler) {
        this.demoHandler = demoHandler;
    }

    protected InternalDemoHandler getDemoHandler() {
        return this.demoHandler;
    }

    public void init() {
        InternalDemoHandler demoHandler = this.getDemoHandler();
        this.setTitle(demoHandler.getDemoName());
        this.setJMenuBar(this.createMenuBar());
        this.setContentPane(this.createDefaultContentPane());
    }

    protected JComponent createDefaultContentPane() {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        InternalDemoHandler demoHandler = this.getDemoHandler();
        JEditorPane editorPane = new JEditorPane();
        URL url = demoHandler.getDemoDescriptionSource();
        editorPane.setEditable(false);
        editorPane.setPreferredSize(new Dimension(400, 200));
        if (url != null) {
            try {
                editorPane.setPage(url);
            }
            catch (IOException e) {
                editorPane.setText("Unable to load the demo description. Error: " + e.getMessage());
            }
        } else {
            editorPane.setText("Unable to load the demo description. No such resource.");
        }
        JScrollPane scroll = new JScrollPane(editorPane, 20, 30);
        JButton previewButton = new JButton(this.getPreviewAction());
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(scroll);
        splitPane.setBottomComponent(demoHandler.getPresentationComponent());
        content.add((Component)splitPane, "Center");
        content.add((Component)previewButton, "South");
        return content;
    }

    @Override
    protected void attemptPreview() {
        InternalDemoHandler demoHandler = this.getDemoHandler();
        PreviewHandler previewHandler = demoHandler.getPreviewHandler();
        previewHandler.attemptPreview();
    }
}

