/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.parser.ConfigReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.parser.XPathQueryReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XPathDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private ConfigReadHandler configReadHandler;
    private ArrayList<XPathQueryReadHandler> queries = new ArrayList();
    private XPathDataFactory dataFactory;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("config".equals(tagName)) {
            this.configReadHandler = new ConfigReadHandler();
            return this.configReadHandler;
        }
        if ("query".equals(tagName)) {
            XPathQueryReadHandler queryReadHandler = new XPathQueryReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        XPathDataFactory srdf = new XPathDataFactory();
        if (this.configReadHandler == null) {
            throw new ParseException("Required element 'config' is missing.", this.getLocator());
        }
        srdf.setXqueryDataFile(this.configReadHandler.getSourceFile());
        for (int i = 0; i < this.queries.size(); ++i) {
            XPathQueryReadHandler handler = this.queries.get(i);
            srdf.setQuery(handler.getName(), handler.getResult(), handler.isLegacyMode());
        }
        this.dataFactory = srdf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

