/*!
* This program is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License, version 2.1 as published by the Free Software
* Foundation.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* program; if not, you can obtain a copy at http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
* or from the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* Copyright (c) 2002-2017 Hitachi Vantara..  All rights reserved.
*/

package org.pentaho.reporting.libraries.css.keys.list;

import org.pentaho.reporting.libraries.css.values.CSSConstant;

/**
 * Creation-Date: 01.12.2005, 18:59:44
 *
 * @author Thomas Morgner
 */
public class ListStyleTypeAlphabetic {
  // afar |  amharic | amharic-abegede | cjk-earthly-branch |
  public static final CSSConstant AFAR =
    new CSSConstant( "afar" );
  public static final CSSConstant AMHARIC =
    new CSSConstant( "amharic" );
  public static final CSSConstant AMHARIC_ABEGEDE =
    new CSSConstant( "amharic-abegede" );
  public static final CSSConstant CJK_EARTHLY_BRANCH =
    new CSSConstant( "cjk-earthly-branch" );

  // cjk-heavenly-stem | ethiopic | ethiopic-abegede |
  public static final CSSConstant CJK_HEAVENLY_STEM =
    new CSSConstant( "cjk-heavenly-stem" );
  public static final CSSConstant ETHIOPIC =
    new CSSConstant( "ethiopic" );
  public static final CSSConstant ETHIOPIC_ABEGEDE =
    new CSSConstant( "ethiopic-abegede" );

  // ethiopic-abegede-am-et |  ethiopic-abegede-gez |
  public static final CSSConstant ETHIOPIC_ABEGEDE_AM_ET =
    new CSSConstant( "ethiopic-abegede-am-et" );
  public static final CSSConstant ETHIOPIC_ABEGEDE_GEZ =
    new CSSConstant( "ethiopic-abegede-gez" );

  // ethiopic-abegede-ti-er |  ethiopic-abegede-ti-et |
  public static final CSSConstant ETHIOPIC_ABEGEDE_TI_ER =
    new CSSConstant( "ethiopic-abegede-ti-er" );
  public static final CSSConstant ETHIOPIC_ABEGEDE_TI_ET =
    new CSSConstant( "ethiopic-abegede-ti-et" );

  // ethiopic-halehame-aa-er | ethiopic-halehame-aa-et |
  public static final CSSConstant ETHIOPIC_HALEHAME_AA_ER =
    new CSSConstant( "ethiopic-halehame-aa-er" );
  public static final CSSConstant ETHIOPIC_HALEHAME_AA_ET =
    new CSSConstant( "ethiopic-halehame-aa-et" );

  // ethiopic-halehame-am-et | ethiopic-halehame-gez |
  public static final CSSConstant ETHIOPIC_HALEHAME_AM_ET =
    new CSSConstant( "ethiopic-halehame-am-et" );
  public static final CSSConstant ETHIOPIC_HALEHAME_GEZ =
    new CSSConstant( "ethiopic-halehame-gez" );

  // ethiopic-halehame-om-et | ethiopic-halehame-sid-et |
  public static final CSSConstant ETHIOPIC_HALEHAME_OM_ET =
    new CSSConstant( "ethiopic-halehame-om-et" );
  public static final CSSConstant ETHIOPIC_HALEHAME_SID_ET =
    new CSSConstant( "ethiopic-halehame-sid-et" );

  // ethiopic-halehame-so-et |  ethiopic-halehame-ti-er |
  public static final CSSConstant ETHIOPIC_HALEHAME_SO_ET =
    new CSSConstant( "ethiopic-halehame-so-et" );
  public static final CSSConstant ETHIOPIC_HALEHAME_TI_ER =
    new CSSConstant( "ethiopic-halehame-ti-er" );

  // ethiopic-halehame-ti-et | ethiopic-halehame-tig |
  public static final CSSConstant ETHIOPIC_HALEHAME_TI_ET =
    new CSSConstant( "ethiopic-halehame-ti-et" );
  public static final CSSConstant ETHIOPIC_HALEHAME_TIG =
    new CSSConstant( "ethiopic-halehame-tig" );

  // hangul | hangul-consonant | hiragana | hiragana-iroha |
  public static final CSSConstant HANGUL =
    new CSSConstant( "hangul" );
  public static final CSSConstant HANGUL_CONSONANT =
    new CSSConstant( "hangul-consonant" );
  public static final CSSConstant HIRAGANA =
    new CSSConstant( "hiragana" );
  public static final CSSConstant HIRAGANA_IROHA =
    new CSSConstant( "hiragana-iroha" );

  // katakana | katakana-iroha | lower-alpha | lower-greek |
  public static final CSSConstant KATAKANA =
    new CSSConstant( "katakana" );
  public static final CSSConstant KATAKANA_IROHA =
    new CSSConstant( "katakana-iroha" );
  public static final CSSConstant LOWER_ALPHA =
    new CSSConstant( "lower-alpha" );
  public static final CSSConstant LOWER_GREEK =
    new CSSConstant( "lower-greek" );

  // lower-norwegian | lower-latin | oromo |  sidama |  somali |
  public static final CSSConstant LOWER_NORWEGIAN =
    new CSSConstant( "lower-norwegian" );
  public static final CSSConstant LOWER_LATIN =
    new CSSConstant( "lower-latin" );
  public static final CSSConstant OROMO =
    new CSSConstant( "oromo" );
  public static final CSSConstant SIDAMA =
    new CSSConstant( "sidama" );
  public static final CSSConstant SOMALI =
    new CSSConstant( "somali" );

  // tigre |  tigrinya-er | tigrinya-er-abegede |  tigrinya-et |
  public static final CSSConstant TIGRE =
    new CSSConstant( "tigre" );
  public static final CSSConstant TIGRINYA_ER =
    new CSSConstant( "tigrinya-er" );
  public static final CSSConstant TIGRINYA_ER_ABEGEDE =
    new CSSConstant( "tigrinya-er-abegede" );
  public static final CSSConstant TIGRINYA_ET =
    new CSSConstant( "tigrinya-et" );
  // tigrinya-et-abegede |  upper-alpha | upper-greek |
  public static final CSSConstant TIGRINYA_ET_ABEGEDE =
    new CSSConstant( "tigrinya-et-abegede" );
  public static final CSSConstant UPPER_ALPHA =
    new CSSConstant( "upper-alpha" );
  public static final CSSConstant UPPER_GREEK =
    new CSSConstant( "upper-greek" );
  // upper-norwegian | upper-latin
  public static final CSSConstant UPPER_NORWEGIAN =
    new CSSConstant( "upper-norwegian" );
  public static final CSSConstant UPPER_LATIN =
    new CSSConstant( "upper-latin" );

  private ListStyleTypeAlphabetic() {
  }
}
