/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.dom;

import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public final class DefaultLayoutStyle
implements LayoutStyle {
    private CSSValue[] values;
    private Object reference;

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    @Override
    public CSSValue getValue(StyleKey key) {
        if (this.values == null) {
            return null;
        }
        return this.values[key.getIndex()];
    }

    @Override
    public void setValue(StyleKey key, CSSValue value) {
        if (this.values == null) {
            this.values = new CSSValue[StyleKeyRegistry.getRegistry().getKeyCount()];
        }
        this.values[key.getIndex()] = value;
    }

    public void dispose() {
    }

    public DefaultLayoutStyle createCopy() {
        DefaultLayoutStyle style = new DefaultLayoutStyle();
        if (this.values == null) {
            style.values = null;
            return style;
        }
        style.values = (CSSValue[])this.values.clone();
        return style;
    }

    public boolean isEmpty() {
        if (this.values == null) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean copyFrom(LayoutStyle style) {
        if (!(style instanceof DefaultLayoutStyle)) {
            return false;
        }
        DefaultLayoutStyle rawstyle = (DefaultLayoutStyle)style;
        if (rawstyle.values == null) {
            return true;
        }
        if (this.values == null) {
            this.values = (CSSValue[])rawstyle.values.clone();
            return true;
        }
        for (CSSValue o : rawstyle.values) {
            if (o == null) continue;
            this.values[i] = o;
        }
        return true;
    }
}

