/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.content;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class CounterModificationReadHandler
implements CSSValueReadHandler {
    public static final CSSNumericValue ZERO = CSSNumericValue.createValue(CSSNumericType.NUMBER, 0.0);

    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() != 35) {
            return null;
        }
        String mayBeNone = value.getStringValue();
        if ("none".equalsIgnoreCase(mayBeNone)) {
            return new CSSConstant("none");
        }
        ArrayList<CSSValuePair> counterSpecs = new ArrayList<CSSValuePair>();
        while (value != null) {
            if (value.getLexicalUnitType() != 35) {
                return null;
            }
            String identifier = value.getStringValue();
            value = value.getNextLexicalUnit();
            CSSValue counterValue = ZERO;
            if (value != null) {
                if (value.getLexicalUnitType() == 13) {
                    counterValue = CSSNumericValue.createValue(CSSNumericType.NUMBER, value.getIntegerValue());
                    value = value.getNextLexicalUnit();
                } else if (value.getLexicalUnitType() == 37) {
                    counterValue = CSSValueFactory.parseAttrFunction(value);
                    value = value.getNextLexicalUnit();
                } else if (CSSValueFactory.isFunctionValue(value)) {
                    counterValue = CSSValueFactory.parseFunction(value);
                    value = value.getNextLexicalUnit();
                }
            }
            counterSpecs.add(new CSSValuePair(new CSSConstant(identifier), counterValue));
        }
        return new CSSValueList(counterSpecs);
    }
}

