/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.values;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.util.ColorUtil;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class HslValueFunction
implements StyleValueFunction {
    protected int validateHueParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(nval.getValue() % 360.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    protected float validateOtherParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (float)(nval.getValue() % 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    @Override
    public boolean isAutoResolveable() {
        return true;
    }

    @Override
    public CSSValue evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] values = function.getParameters();
        if (values.length == 3) {
            int hueValue = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            float saturationValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            float lightValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            float[] rgb = ColorUtil.hslToRGB(hueValue, saturationValue, lightValue);
            return new CSSColorValue(rgb[0], rgb[1], rgb[2]);
        }
        if (values.length == 4) {
            int hueValue = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            float saturationValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            float lightValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            float alphaValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[3]));
            float[] rgb = ColorUtil.hslToRGB(hueValue, saturationValue, lightValue);
            return new CSSColorValue(rgb[0], rgb[1], rgb[2], alphaValue);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

