/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.tokens.resolved;

import org.pentaho.reporting.libraries.css.counter.CounterStyle;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.CountersToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.types.TextType;

public class ResolvedCountersToken
implements TextType {
    private CountersToken parent;
    private int[] counterValues;

    public ResolvedCountersToken(CountersToken parent, int[] counterValues) {
        this.parent = parent;
        this.counterValues = counterValues;
    }

    public CountersToken getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        CountersToken counterToken = this.getParent();
        CounterStyle style = counterToken.getStyle();
        String separator = counterToken.getSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.counterValues.length; ++i) {
            if (i != 0) {
                buffer.append(separator);
            }
            int value = this.counterValues[i];
            buffer.append(style.getCounterValue(value));
        }
        return buffer.toString();
    }

    public int[] getCounterValue() {
        return (int[])this.counterValues.clone();
    }
}

