/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.autovalue.box;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.text.BlockProgression;
import org.pentaho.reporting.libraries.css.keys.text.Direction;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;

public class FitPositionResolveHandler
implements ResolveHandler {
    private static final CSSNumericValue LEFT_TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    private static final CSSNumericValue RIGHT_BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{TextStyleKeys.BLOCK_PROGRESSION, TextStyleKeys.DIRECTION};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        boolean rightToLeft = Direction.RTL.equals(layoutContext.getValue(TextStyleKeys.DIRECTION));
        CSSValue blockProgression = layoutContext.getValue(TextStyleKeys.BLOCK_PROGRESSION);
        if (BlockProgression.TB.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, LEFT_TOP));
            } else {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            }
        } else if (BlockProgression.RL.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            } else {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, LEFT_TOP));
            }
        } else if (BlockProgression.LR.equals(blockProgression)) {
            if (rightToLeft) {
                layoutContext.setValue(key, new CSSValuePair(RIGHT_BOTTOM, RIGHT_BOTTOM));
            } else {
                layoutContext.setValue(key, new CSSValuePair(LEFT_TOP, LEFT_TOP));
            }
        }
    }
}

