/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed;

import java.util.HashMap;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public abstract class ConstantsResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_STYLE_KEYS = new StyleKey[0];
    private HashMap constants = new HashMap();
    private CSSValue fallback;

    protected ConstantsResolveHandler() {
    }

    public CSSValue getFallback() {
        return this.fallback;
    }

    protected void setFallback(CSSValue fallback) {
        this.fallback = fallback;
    }

    protected CSSValue lookupValue(CSSConstant value) {
        return (CSSValue)this.constants.get(value);
    }

    protected void addValue(CSSConstant constant, CSSValue value) {
        this.constants.put(constant, value);
    }

    protected void addNormalizeValue(CSSConstant constant) {
        this.constants.put(constant, constant);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return EMPTY_STYLE_KEYS;
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = this.resolveValue(process, currentNode, key);
        if (value != null) {
            currentNode.getLayoutStyle().setValue(key, value);
        }
    }

    protected CSSValue resolveValue(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSConstant)) {
            CSSValue fallback = this.getFallback();
            if (fallback != null) {
                return fallback;
            }
            return null;
        }
        CSSConstant constant = (CSSConstant)value;
        CSSValue resolvedValue = this.lookupValue(constant);
        if (resolvedValue != null) {
            return resolvedValue;
        }
        CSSValue fallback = this.getFallback();
        if (fallback != null) {
            return fallback;
        }
        return null;
    }
}

