/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.border;

import java.util.HashMap;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.border.BorderWidth;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class BorderWidthResolveHandler
extends ConstantsResolveHandler {
    private HashMap keyMapping = new HashMap();

    public BorderWidthResolveHandler() {
        this.keyMapping.put(BorderStyleKeys.BORDER_TOP_WIDTH, BorderStyleKeys.BORDER_TOP_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_LEFT_WIDTH, BorderStyleKeys.BORDER_LEFT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, BorderStyleKeys.BORDER_BOTTOM_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, BorderStyleKeys.BORDER_RIGHT_STYLE);
        this.keyMapping.put(BorderStyleKeys.BORDER_BREAK_WIDTH, BorderStyleKeys.BORDER_BREAK_STYLE);
        this.addValue(BorderWidth.THIN, CSSNumericValue.createValue(CSSNumericType.PT, 1.0));
        this.addValue(BorderWidth.MEDIUM, CSSNumericValue.createValue(CSSNumericType.PT, 3.0));
        this.addValue(BorderWidth.THICK, CSSNumericValue.createValue(CSSNumericType.PT, 5.0));
        this.setFallback(CSSNumericValue.ZERO_LENGTH);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_STYLE, BorderStyleKeys.BORDER_LEFT_STYLE, BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyleKeys.BORDER_BREAK_STYLE};
    }

    @Override
    protected CSSValue resolveValue(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        StyleKey borderStyleKey = (StyleKey)this.keyMapping.get(key);
        if (borderStyleKey == null) {
            throw new IllegalArgumentException("This is not a valid key: " + key);
        }
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue borderStyle = layoutContext.getValue(borderStyleKey);
        if (BorderStyle.NONE.equals(borderStyle)) {
            return CSSNumericValue.ZERO_LENGTH;
        }
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant) {
            return super.resolveValue(process, currentNode, key);
        }
        return value;
    }
}

