/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.content;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.keys.content.ContentStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSAttrFunction;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CounterIncrementResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement element, StyleKey key) {
    }

    private int parseCounterValue(CSSValue rawValue, LayoutElement element) {
        if (rawValue instanceof CSSNumericValue) {
            CSSNumericValue nval = (CSSNumericValue)rawValue;
            return (int)nval.getValue();
        }
        if (rawValue instanceof CSSAttrFunction) {
            CSSAttrFunction attrFunction = (CSSAttrFunction)rawValue;
            String attrName = attrFunction.getName();
            String attrNamespace = attrFunction.getNamespace();
            Object rawAttribute = element.getAttribute(attrNamespace, attrName);
            if (rawAttribute instanceof Number) {
                Number nAttr = (Number)rawAttribute;
                return nAttr.intValue();
            }
        }
        return 0;
    }
}

