/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.text;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class TextKashidaSpaceResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (!CSSNumericType.PERCENTAGE.equals(nval.getType())) {
            return;
        }
        double percentage = nval.getValue();
        if (percentage < 0.0) {
            percentage = 0.0;
        }
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        layoutContext.setValue(TextStyleKeys.TEXT_KASHIDA_SPACE, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, percentage));
    }
}

