/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.text;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;

public class TextOverflowEllipsisResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        CSSStringValue lineEllipsis = null;
        CSSStringValue blockEllipsis = null;
        if (value instanceof CSSValueList) {
            CSSValueList vlist = (CSSValueList)value;
            if (vlist.getLength() == 2) {
                lineEllipsis = this.filterString(vlist.getItem(0));
                blockEllipsis = this.filterString(vlist.getItem(1));
            } else if (vlist.getLength() == 1) {
                lineEllipsis = this.filterString(vlist.getItem(0));
                blockEllipsis = this.filterString(vlist.getItem(0));
            }
        }
        if (lineEllipsis == null) {
            lineEllipsis = new CSSStringValue(CSSStringType.STRING, "..");
        }
        if (blockEllipsis == null) {
            blockEllipsis = new CSSStringValue(CSSStringType.STRING, "..");
        }
        layoutContext.setValue(TextStyleKeys.X_BLOCK_TEXT_OVERFLOW_ELLIPSIS, blockEllipsis);
        layoutContext.setValue(TextStyleKeys.X_LINE_TEXT_OVERFLOW_ELLIPSIS, lineEllipsis);
    }

    private CSSStringValue filterString(CSSValue value) {
        if (!(value instanceof CSSStringValue)) {
            return null;
        }
        return (CSSStringValue)value;
    }
}

