/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.percentages.fonts;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public class FontSizeAdjustResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_EFFECT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_WEIGHT};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (!CSSNumericType.NUMBER.equals(nval.getType())) {
            return;
        }
        LayoutElement parent = currentNode.getParentLayoutElement();
        if (parent == null) {
            return;
        }
        double adjustFactor = nval.getValue();
        FontMetrics fontMetrics = process.getOutputMetaData().getFontMetrics(layoutContext);
        if (fontMetrics == null) {
            return;
        }
        double actualFontXHeight = FontStrictGeomUtility.toExternalValue((long)fontMetrics.getXHeight());
        double fontSize = fontMetrics.getAscent();
        double aspectRatio = actualFontXHeight / fontSize;
        double result = fontSize * (adjustFactor / aspectRatio);
        layoutContext.setValue(FontStyleKeys.FONT_SIZE, CSSNumericValue.createPtValue(result));
    }
}

