/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.selectors.conditions;

import org.pentaho.reporting.libraries.css.selectors.conditions.AndCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.AttributeCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.BeginHyphenAttributeCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.CSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.ContentCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.IdCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.LangCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.NegativeCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.OneOfAttributeCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.OrCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.PositionalCSSCondition;
import org.pentaho.reporting.libraries.css.selectors.conditions.PseudoClassCSSCondition;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.PositionalCondition;

public class CSSConditionFactory
implements ConditionFactory {
    public CombinatorCondition createAndCondition(Condition first, Condition second) throws CSSException {
        return new AndCSSCondition((CSSCondition)first, (CSSCondition)second);
    }

    public CombinatorCondition createOrCondition(Condition first, Condition second) throws CSSException {
        return new OrCSSCondition((CSSCondition)first, (CSSCondition)second);
    }

    public NegativeCondition createNegativeCondition(Condition condition) throws CSSException {
        return new NegativeCSSCondition((CSSCondition)condition);
    }

    public PositionalCondition createPositionalCondition(int position, boolean typeNode, boolean type) throws CSSException {
        return new PositionalCSSCondition(position, typeNode, type);
    }

    public AttributeCondition createAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        return new AttributeCSSCondition(localName, namespaceURI, specified, value);
    }

    public AttributeCondition createIdCondition(String value) throws CSSException {
        return new IdCSSCondition(value);
    }

    public LangCondition createLangCondition(String lang) throws CSSException {
        return new LangCSSCondition(lang);
    }

    public AttributeCondition createOneOfAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        return new OneOfAttributeCSSCondition(localName, namespaceURI, specified, value);
    }

    public AttributeCondition createClassCondition(String namespaceURI, String value) throws CSSException {
        return new AttributeCSSCondition("class", namespaceURI, true, value);
    }

    public AttributeCondition createPseudoClassCondition(String namespaceURI, String value) throws CSSException {
        return new PseudoClassCSSCondition(namespaceURI, value);
    }

    public AttributeCondition createBeginHyphenAttributeCondition(String localName, String namespaceURI, boolean specified, String value) throws CSSException {
        return new BeginHyphenAttributeCSSCondition(localName, namespaceURI, specified, value);
    }

    public Condition createOnlyChildCondition() throws CSSException {
        return null;
    }

    public Condition createOnlyTypeCondition() throws CSSException {
        return null;
    }

    public ContentCondition createContentCondition(String data) throws CSSException {
        return new ContentCSSCondition(data);
    }
}

