/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class GroupLayoutUtil {
    private GroupLayoutUtil() {
    }

    public static JPanel makeSimpleForm(int rows, int cols, Component ... components) {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup();
        for (int c = 0; c < cols; ++c) {
            GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
            for (int r = 0; r < rows; ++r) {
                int index = r * cols + c;
                parallelGroup.addComponent(components[index]);
            }
            horizontalGroup.addGroup(parallelGroup);
        }
        layout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        for (int r = 0; r < rows; ++r) {
            GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
            for (int c = 0; c < cols; ++c) {
                int index = r * cols + c;
                parallelGroup.addComponent(components[index]);
            }
            verticalGroup.addGroup(parallelGroup);
        }
        layout.setVerticalGroup(verticalGroup);
        return panel;
    }
}

