/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.bulk;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class RemoveBulkAction
extends AbstractAction {
    private BulkDataProvider tableModel;
    private ListSelectionModel listSelectionModel;
    private JTable editorTable;

    public RemoveBulkAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel) {
        this.tableModel = tableModel;
        this.listSelectionModel = listSelectionModel;
        this.listSelectionModel.addListSelectionListener(new SelectionUpdateHandler());
        this.putValue("SmallIcon", Messages.getInstance().getIcon("Icons.REMOVE"));
        this.putValue("ShortDescription", Messages.getInstance().getString("Action.REMOVE"));
    }

    public RemoveBulkAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel, JTable editorTable) {
        this(tableModel, listSelectionModel);
        this.editorTable = editorTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TableCellEditor cellEditor;
        if (this.listSelectionModel.isSelectionEmpty()) {
            return;
        }
        if (this.editorTable != null && (cellEditor = this.editorTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        Object[] data = this.tableModel.getBulkData();
        ArrayList<Object> result = new ArrayList<Object>(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (this.listSelectionModel.isSelectedIndex(i)) continue;
            result.add(data[i]);
        }
        this.tableModel.setBulkData(result.toArray());
    }

    private class SelectionUpdateHandler
    implements ListSelectionListener {
        private SelectionUpdateHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            RemoveBulkAction.this.setEnabled(!RemoveBulkAction.this.listSelectionModel.isSelectionEmpty());
        }
    }
}

