/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.transfer.common.configuration;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.xforceplus.feign.global.org.OrgFeignClient;
import com.xforceplus.invoice.transfer.common.configuration.FieldMappings;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@MapperScan(value={"com.xforceplus.invoice.transfer.common.dao.impl"})
@EnableConfigurationProperties(value={FieldMappings.class})
@EnableFeignClients(basePackages={"com.xforceplus"}, clients={OrgFeignClient.class})
public class TransferConfiguration {
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLimit(100L);
        paginationInterceptor.setCountSqlParser((ISqlParser)new JsqlParserCountOptimize(true));
        paginationInterceptor.setDbType(DbType.MYSQL);
        return paginationInterceptor;
    }

    @EnableApolloConfig
    @Profile(value={"!local"})
    @Configuration
    public static class ApolloConfig {
    }

    @Configuration
    public static class WebMvcConfiguration
    implements WebMvcConfigurer {
        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
            converters.add(0, (HttpMessageConverter<?>)stringHttpMessageConverter);
            MappingJackson2HttpMessageConverter jsonMessageConverter = new MappingJackson2HttpMessageConverter();
            converters.add(1, (HttpMessageConverter<?>)jsonMessageConverter);
        }
    }
}

