/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.transfer.common.policy.update;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.transfer.common.policy.update.IUpdater;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractUpdater<T extends BaseDomain>
implements IUpdater<T> {
    private Set<String> columns;
    private Map<String, TableFieldInfo> fieldInfoMap;

    protected abstract Collection<String> initColumns();

    protected abstract int compare(T var1, T var2);

    @Override
    public void compareAndSet(T source, T destination) {
        this.set(source, destination, this.compare(source, destination) < 0);
    }

    protected void set(T source, T destination, boolean setSourceValue) {
        this.columns.forEach(column -> {
            Field field;
            TableFieldInfo tableFieldInfo = this.fieldInfoMap.get(column);
            if (tableFieldInfo != null && !Modifier.isStatic((field = tableFieldInfo.getField()).getModifiers()) && !Modifier.isFinal(field.getModifiers())) {
                field.setAccessible(true);
                try {
                    Object sourceValue = field.get(source);
                    Object desValue = field.get(destination);
                    if (setSourceValue) {
                        field.set(destination, Optional.ofNullable(sourceValue).orElse(desValue));
                    } else {
                        field.set(destination, Optional.ofNullable(desValue).orElse(sourceValue));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @PostConstruct
    private void init() {
        this.columns = new HashSet<String>();
        Collection<String> cols = this.initColumns();
        if (CollectionUtils.isNotEmpty(cols)) {
            this.columns.addAll(cols);
        }
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)((Class)type.getActualTypeArguments()[0]));
        this.fieldInfoMap = tableInfo.getFieldList().stream().collect(Collectors.toMap(TableFieldInfo::getColumn, info -> info, (o, n) -> n));
    }
}

