/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.transfer.common.policy.update;

import com.xforceplus.invoice.common.constant.ChannelSource;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.domain.typehandler.BusinessExtendMap;
import com.xforceplus.invoice.transfer.common.policy.update.AbstractUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class BusinessExtendUpdater<T extends BaseDomain>
extends AbstractUpdater<T> {
    private Collection<String> columns = Optional.ofNullable(this.initColumns()).orElse(new ArrayList());

    public boolean isAllColumn() {
        return false;
    }

    @Override
    protected Collection<String> initColumns() {
        return null;
    }

    @Override
    protected int compare(T source, T destination) {
        boolean sourceFlag = ChannelSource.fromCode((int)source.getChannelSource()).isBusinessPlatform();
        boolean destinationFlag = ChannelSource.fromCode((int)destination.getChannelSource()).isBusinessPlatform();
        if (sourceFlag) {
            if (destinationFlag) {
                return 1;
            }
            return -1;
        }
        if (destinationFlag) {
            return 1;
        }
        return 1;
    }

    @Override
    public void compareAndSet(T source, T destination) {
        if (this.compare(source, destination) < 0) {
            ChannelSource channelSource = ChannelSource.fromCode((int)source.getChannelSource());
            ChannelSource desChannel = ChannelSource.fromCode((int)destination.getChannelSource());
            if (source.getBusinessExtend() != null) {
                Map souceMap = Optional.ofNullable((Map)source.getBusinessExtend().get((Object)channelSource.getIdentifier())).orElse(new HashMap());
                if (destination.getBusinessExtend() != null) {
                    Map desMap = Optional.ofNullable((Map)destination.getBusinessExtend().get((Object)desChannel.getIdentifier())).orElse(new HashMap());
                    if (this.isAllColumn()) {
                        desMap.putAll(souceMap);
                    } else {
                        this.columns.forEach(col -> desMap.put(col, souceMap.get(col)));
                    }
                }
            }
            if (destination.getBusinessExtend() == null) {
                BusinessExtendMap map = new BusinessExtendMap();
                map.put((Object)desChannel.getIdentifier(), new HashMap());
                destination.setBusinessExtend(map);
            }
        }
    }
}

