/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.transfer.common.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.invoice.common.constant.ChannelSource;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.domain.typehandler.BusinessExtendMap;
import com.xforceplus.invoice.domain.typehandler.InvoiceExtendMap;
import com.xforceplus.invoice.transfer.common.consumer.EntityDataConverter;
import com.xforceplus.invoice.transfer.common.policy.update.IUpdater;
import com.xforceplus.invoice.transfer.common.remote.RemoteInvoiceItemHolder;
import com.xforceplus.invoice.transfer.common.remote.service.RemoteInvoiceItemService;
import com.xforceplus.invoice.transfer.common.service.InvoiceItemService;
import com.xforceplus.invoice.transfer.common.service.SystemService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public abstract class AbstractInvoiceMainService<DAO extends BaseMapper<T>, T extends BaseDomain>
extends ServiceImpl<DAO, T>
implements SystemService<T, Long> {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RemoteInvoiceItemHolder remoteInvoiceItemHolder;
    @Autowired
    private EntityDataConverter entityDataConverter;

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public boolean save(T entity) {
        T source = this.getByNoAndCode(entity.getInvoiceNo(), entity.getInvoiceCode());
        return this.doSave(source, entity);
    }

    private boolean doSave(T source, T destination) {
        destination.setSynchronizeTime(LocalDateTime.now());
        if (source != null) {
            if (!this.validateDestination(source, destination)) {
                return false;
            }
            BusinessExtendMap business = destination.getBusinessExtend();
            BusinessExtendMap businessSource = source.getBusinessExtend();
            if (businessSource != null) {
                if (business != null) {
                    businessSource.putAll(business);
                }
                BusinessExtendMap map = new BusinessExtendMap();
                map.putAll((Map)businessSource);
                destination.setBusinessExtend(map);
            }
            InvoiceExtendMap invoiceExtend = destination.getInvoiceExtend();
            InvoiceExtendMap invoiceExtendSource = source.getInvoiceExtend();
            if (invoiceExtendSource != null) {
                if (invoiceExtend != null) {
                    invoiceExtendSource.putAll((Map)invoiceExtend);
                }
                destination.setInvoiceExtend(invoiceExtendSource);
            }
            if (source.getChannelSource().compareTo(destination.getChannelSource()) == 0) {
                return this.updateDomain4SameSource(source, destination);
            }
            this.compareAndSet(source, destination);
            return this.invokeUpdate(source, destination);
        }
        destination.setHashValue("");
        destination.setCreateTime(LocalDateTime.now());
        return super.save(destination);
    }

    @Override
    public boolean save(T domain, boolean isInsert) {
        T source = this.getByNoAndCode(domain.getInvoiceNo(), domain.getInvoiceCode());
        if (isInsert) {
            ChannelSource channelSource = ChannelSource.fromCode((int)domain.getChannelSource());
            Optional.ofNullable(this.remoteInvoiceItemHolder.getRemoteInvoiceItemServiceByChannel(channelSource.getIdentifier())).ifPresent(itemService -> this.processCreateItems((RemoteInvoiceItemService<Map>)itemService, domain, source == null, channelSource));
        }
        return this.doSave(source, domain);
    }

    private void processCreateItems(RemoteInvoiceItemService<Map> remoteInvoiceItemService, T domain, boolean isRealInsert, ChannelSource channelSource) {
        List<Map> datas = remoteInvoiceItemService.getList(domain.getInvoiceNo(), domain.getInvoiceCode(), domain.getId());
        ArrayList items = new ArrayList();
        Optional.ofNullable(datas).ifPresent(itemMaps -> itemMaps.forEach(map -> {
            Object entity = this.entityDataConverter.convert(this.getItemClass(), (Map<String, Serializable>)map, channelSource);
            entity.setGenerateChannel(channelSource.getCode());
            items.add(entity);
        }));
        if (!items.isEmpty()) {
            if (isRealInsert) {
                this.getItemService().saveBatch(items, 1000);
            } else {
                this.getItemService().compareAndUpdateItems(domain.getInvoiceNo(), domain.getInvoiceCode(), channelSource, items);
            }
        }
    }

    protected abstract <I extends BaseDomain> InvoiceItemService<I, Long> getItemService();

    protected abstract <I extends BaseDomain> Class<I> getItemClass();

    private void compareAndSet(T source, T destination) {
        Collection<IUpdater<IUpdater>> updaters = this.getUpdaters();
        if (!CollectionUtils.isEmpty(updaters)) {
            updaters.forEach(updater -> updater.compareAndSet(source, destination));
        }
    }

    protected abstract Collection<? extends IUpdater<T>> getUpdaters();

    private boolean updateDomain4SameSource(T source, T destination) {
        destination.setId(source.getId());
        return this.invokeUpdate(source, destination);
    }

    protected boolean invokeUpdate(T source, T destination) {
        return this.getBaseMapper().update(destination, (Wrapper)((UpdateWrapper)((UpdateWrapper)Wrappers.update().eq((Object)"id", (Object)destination.getId())).eq((Object)"invoice_no", (Object)source.getInvoiceNo())).eq((Object)"invoice_code", (Object)source.getInvoiceCode())) > 0;
    }

    public T getByNoAndCode(String invoiceNo, String invoiceCode) {
        return (T)((BaseDomain)this.getBaseMapper().selectOne((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"invoice_no", (Object)invoiceNo)).eq((Object)"invoice_code", (Object)invoiceCode)));
    }

    protected boolean validateDestination(T source, T destination) {
        return true;
    }
}

