/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.invoice.transfer.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.invoice.common.constant.InvoiceStatus;
import com.xforceplus.invoice.common.constant.PurchaserInvoiceColor;
import com.xforceplus.invoice.domain.BaseDomain;
import com.xforceplus.invoice.domain.entity.InvoicePurchaserItem;
import com.xforceplus.invoice.domain.entity.InvoicePurchaserMain;
import com.xforceplus.invoice.transfer.common.dao.impl.TransferInvoicePurchaserMainDao;
import com.xforceplus.invoice.transfer.common.policy.update.purchase.IPurchaserUpdater;
import com.xforceplus.invoice.transfer.common.service.AbstractInvoiceMainService;
import com.xforceplus.invoice.transfer.common.service.InvoicePurchaserItemService;
import com.xforceplus.invoice.transfer.common.service.InvoicePurchaserMainService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoicePurchaserMainServiceImpl
extends AbstractInvoiceMainService<TransferInvoicePurchaserMainDao, InvoicePurchaserMain>
implements InvoicePurchaserMainService {
    private static final Logger log = LoggerFactory.getLogger(InvoicePurchaserMainServiceImpl.class);
    private Collection<IPurchaserUpdater> purchaseUpdaters = Collections.emptyList();
    @Autowired
    private InvoicePurchaserItemService invoicePurchaserItemService;

    @PostConstruct
    public void initUpdaters() {
        Map beans = this.getApplicationContext().getBeansOfType(IPurchaserUpdater.class);
        if (!CollectionUtils.isEmpty((Map)beans)) {
            this.purchaseUpdaters = new ArrayList<IPurchaserUpdater>(beans.size());
            beans.values().forEach(bean -> {
                boolean bl = this.purchaseUpdaters.add((IPurchaserUpdater)bean);
            });
        }
    }

    protected InvoicePurchaserItemService getItemService() {
        return this.invoicePurchaserItemService;
    }

    @Override
    protected Class<? extends BaseDomain> getItemClass() {
        return InvoicePurchaserItem.class;
    }

    @Override
    protected Collection<IPurchaserUpdater> getUpdaters() {
        return this.purchaseUpdaters;
    }

    @Override
    protected boolean invokeUpdate(InvoicePurchaserMain source, InvoicePurchaserMain destination) {
        return ((TransferInvoicePurchaserMainDao)this.getBaseMapper()).update(destination, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(InvoicePurchaserMain::getId, (Object)destination.getId())).eq(BaseDomain::getInvoiceNo, (Object)destination.getInvoiceNo())).eq(InvoicePurchaserMain::getInvoiceCode, (Object)destination.getInvoiceCode())).eq(InvoicePurchaserMain::getStatus, (Object)source.getStatus())) > 0;
    }

    @Override
    protected boolean validateDestination(InvoicePurchaserMain source, InvoicePurchaserMain destination) {
        if (source.getStatus() != null && source.getStatus().compareTo(InvoiceStatus.CANCEL.getCode()) == 0 && destination.getStatus() != null && destination.getStatus().compareTo(InvoiceStatus.NORMAL.getCode()) == 0) {
            log.info("\u53d1\u7968[no:{}->code{}]\u5df2\u7ecf\u88ab\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u66f4\u65b0\u6210[\u6b63\u5e38]\u72b6\u6001", (Object)source.getInvoiceNo(), (Object)source.getInvoiceCode());
            return false;
        }
        if (source.getInvoiceColor() != null) {
            source.getInvoiceColor().compareTo(PurchaserInvoiceColor.BLUE.getCode());
        }
        return true;
    }
}

