package com.xforceplus.tower.order.api;

import com.xforceplus.tower.order.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;

@Api
@Validated
public interface OrderApi {

    /**
     * 新增订单
     */
    @ApiOperation(value = "新增订单信息")
    @RequestMapping(value = "/{tenantId}/order/v1/orders", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<OrderIdsData> createOrder(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                           @ApiParam(required = true, value = "产品线id") @NotNull @RequestParam("appId") Long appId,
                                           @ApiParam(required = true, value = "订单信息") @Valid @NotNull @RequestBody Order order);



    /**
     * 修改订单信息
     */
    @ApiOperation(value = "修改订单信息")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}", produces = {"application/json"}, method = RequestMethod.PATCH)
    BaseResponse<String> modifyOrder(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                           @ApiParam(required = true, value = "产品线id") @NotNull @RequestParam("appId") Long appId,
                                           @ApiParam(required = true, value = "订单id") @PathVariable Long id,
                                           @ApiParam(required = true, value = "订单信息") @Valid @NotNull @RequestBody UpdateOrder updateOrder);



    /**
     * 对已存在订单新增订单明细
     */
    @ApiOperation(value = "对已存在订单新增订单明细")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}/items", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<OrderIdsData> addOrderItems(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                             @ApiParam(required = true, value = "产品线id") @NotNull @RequestParam("appId") Long appId,
                                             @ApiParam(required = true, value = "订单id") @PathVariable Long id,
                                             @ApiParam(required = true, value = "新增明细信息") @RequestBody @Valid AddOrderItem addOrderItem);


    /**
     * 修改订单信息，整个覆盖
     */
    @ApiOperation(value = "修改订单信息,整个覆盖")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}", produces = {"application/json"}, method = RequestMethod.PUT)
    BaseResponse<OrderIdsData> coverOrder(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                     @ApiParam(required = true, value = "产品线id") @NotNull @RequestParam("appId") Long appId,
                                     @ApiParam(required = true, value = "订单id") @PathVariable Long id,
                                     @ApiParam(required = true, value = "需修改的订单信息") @RequestBody @Valid @NotNull Order order);


    /**
     * 根据id查询订单
     */
    @ApiOperation(value = "查询订单信息")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}", produces = {"application/json"}, method = RequestMethod.GET)
    BaseResponse<QueryOrderResponse> queryOrder(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                                @ApiParam(required = true, value = "产品线id")@NotNull @RequestParam("appId") Long appId,
                                                @ApiParam(required = true, value = "订单id") @PathVariable Long id,
                                                @ApiParam(value = "订单关联信息", allowableValues = "invoice,") @RequestParam(required = false) String relationship);




    @ApiOperation(value = "根据业务方订单号查询订单")
    @RequestMapping(value = "/{tenantId}/order/v1/orders", produces = {"application/json"}, method = RequestMethod.GET)
    BaseResponse<QueryOrderResponse> queryOrderByOrderNo(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                                         @ApiParam(required = true, value = "产品线id")@NotNull @RequestParam("appId") Long appId,
                                                         @ApiParam(value = "订单生成时间,yyyy-MM-dd") @RequestParam(required = false) @DateTimeFormat(iso = DateTimeFormat.ISO.DATE) LocalDate orderDate,
                                                         @ApiParam(value = "订单号", required = true) @RequestParam @NotEmpty String orderNo,
                                                         @ApiParam(value = "订单关联信息", allowableValues = "invoice") @RequestParam(required = false) String relationship);

    /**
     * 删除订单以及明细信息 高
     */
    @ApiOperation(value = "删除订单信息")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}", produces = {"application/json"}, method = RequestMethod.DELETE)
    BaseResponse<String> deleteOrder(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                     @ApiParam(required = true, value = "产品线id")@NotNull @RequestParam("appId") Long appId,
                                     @ApiParam(required = true, value = "订单id") @PathVariable Long id);


    /**
     * 删除订单明细信息 高
     */
    @ApiOperation(value = "删除订单明细信息")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{id}/items", produces = {"application/json"}, method = RequestMethod.DELETE)
    BaseResponse<String> deleteOrderItem(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                         @ApiParam(required = true, value = "产品线id")@NotNull @RequestParam("appId") Long appId,
                                         @ApiParam(required = true, value = "订单id") @PathVariable Long id,
                                         @ApiParam(required = true, value = "删除明细信息") @RequestBody @Valid DeleteOrderItem deleteOrderItem);


}
