package com.xforceplus.tower.order.api;

import com.xforceplus.tower.order.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;

@Api
@Validated
public interface OrderInvoiceApi {

    @ApiOperation(value = "对已存在的订单新增发票关系")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/{orderId}/invoices", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<String> addOrderInvoiceRelationShip(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                                     @ApiParam(required = true, value = "产品线id") @RequestParam("appId") @NotNull(message = "产品线id不能为空") Long appId,
                                                     @ApiParam(required = true, value = "订单id") @PathVariable Long orderId,
                                                     @ApiParam(required = true, value = "订单与发票关系信息") @Valid @RequestBody @NotEmpty List<OrderInvoiceRelation> orderInvoiceRelations);




    @ApiOperation(value = "发票作废")
    @RequestMapping(value = "/{tenantId}/order/v1/orders/invoices/{invoiceNo}/{invoiceCode}", produces = {"application/json"}, method = RequestMethod.PUT)
    BaseResponse<String> discardInvoice(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") Long tenantId,
                                        @ApiParam(required = true, value = "产品线id") @RequestParam("appId") Long appId,
                                        @ApiParam(required = true, value = "发票号码") @PathVariable("invoiceNo") String invoiceNo,
                                        @ApiParam(required = true, value = "发票代码") @PathVariable("invoiceCode") String invoiceCode);
}
