package com.xforceplus.tower.order.constant;

import com.fasterxml.jackson.annotation.JsonValue;

public enum ConditionOption {
    //
    FALSE(0),
    TRUE(1);

    private int value;

    ConditionOption(int value) {
        this.value = value;
    }

    @JsonValue
    public int getValue() {
        return value;
    }


    public static ConditionOption fromValue(Byte value) {
        for (ConditionOption conditionOption : ConditionOption.values()) {
            if (conditionOption.value == value) {
                return conditionOption;
            }
        }
        throw new IllegalArgumentException(String.format("value = [%s] is illegal", value));
    }

    @Override
    public String toString() {
        return this.ordinal() + "";
    }
}
