package com.xforceplus.tower.order.constant;

import com.fasterxml.jackson.annotation.JsonValue;

public enum  InvoiceStatus {

    /**
     * 作废
     */
    ZUO_FEI(0),

    /**
     * 正常
     */
    ZHENG_CHANG(1),

    /**
     * 红冲
     */
    HONG_CHONG(2);

    private int value;

    InvoiceStatus(int value) {
        this.value = value;
    }

    @JsonValue
    public int getValue() {
        return value;
    }

    public static InvoiceStatus fromValue(Integer value) {
        for (InvoiceStatus invoiceStatus : InvoiceStatus.values()) {
            if (invoiceStatus.value == value) {
                return invoiceStatus;
            }
        }
        throw new IllegalArgumentException();
    }

}
