package com.xforceplus.tower.order.constant;

public enum  Relationship {
    /**
     * 发票
     */
    INVOICE("invoice");

    private String code;
    Relationship(String code) {
        this.code = code;
    }

    public static Relationship from(String code) {
        for (Relationship relationship : Relationship.values()) {
            if (relationship.code.equals(code)) {
                return relationship;
            }
        }
        throw new IllegalArgumentException(String.format("code = [%s] is illegal", code));
    }
}
