package com.xforceplus.tower.order.constant;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * 零税率标识
 */
public enum ZeroTax {

    //零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率

    CHU_KOU_TUI_SHUI(0),
    MIAN_SHUI(1),
    BU_ZHENG_SHUI(2),
    PU_TONG_LING_SHUI_LV(3);

    private int value;

    ZeroTax(int value) {
        this.value = value;
    }

    public static ZeroTax fromValue(Integer value) {
        for (ZeroTax zeroTax : ZeroTax.values()) {
            if (zeroTax.value == value) {
                return zeroTax;
            }
        }
        throw new IllegalArgumentException(String.format("value = [%s] for ZeroTax is illegal", value));
    }

    @JsonValue
    public int getValue() {
        return value;
    }

    @Override
    public String toString() {
        return this.ordinal() + "";
    }
}
