package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;
import java.util.List;

@ApiModel
@Data
public class AddOrderItem {

    @ApiModelProperty(value = "新增明细后主信息不含税金额")
    @PositiveOrZero(message = "不含税金额不能为负")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "新增明细后主信息税额")
    @PositiveOrZero(message = "税额不能为负")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "新增明细后主信息含税金额", required = true)
    @NotNull(message = "新增明细后主信息含税金额不能为空")
    @Positive(message = "新增明细后主信息含税金额必须大于零")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "新增明细后折扣不含税金额")
    @PositiveOrZero(message = "折扣不含税金额不能为负")
    private BigDecimal discountAmountWithoutTax;

    @ApiModelProperty(value = "新增明细后折扣税额")
    @PositiveOrZero(message = "折扣税额不能为负")
    private BigDecimal discountTaxAmount;

    @ApiModelProperty(value = "新增明细后折扣含税金额")
    @PositiveOrZero(message = "折扣含税金额不能为负")
    private BigDecimal discountAmountWithTax;

    @NotEmpty
    @Valid
    private List<OrderItem> orderItemList;
}
