package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import lombok.Data;

@ApiModel
@Data
public class BaseResponse<T> {

    public static final String SUCCESS_CODE = "BSCTZZ0001";

    public static final String PARAM_ERROR = "BSCTZZ0400";

    public static final String NOT_FOUND = "BSCTZZ0404";

    public static final String SYSTEM_ERROR = "BSCTZZ0500";

    private String code;

    private String message;

    private T result;

    public static <E> BaseResponse<E> Ok() {
        BaseResponse<E> baseResponse = new BaseResponse<>();
        baseResponse.setCode(SUCCESS_CODE);
        baseResponse.setMessage("success");
        return baseResponse;
    }

    public static <E> BaseResponse<E> Ok(String message) {
        BaseResponse<E> baseResponse = new BaseResponse<>();
        baseResponse.setCode(SUCCESS_CODE);
        baseResponse.setMessage(message);
        return baseResponse;
    }
}
