package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;

@ApiModel
@Data
public class DiscountInfo {

    @ApiModelProperty(value = "价内折扣不含税金额")
    @PositiveOrZero(message = "价内折扣不含税金额不能为负数")
    private BigDecimal innerDiscountWithoutTax;

    @ApiModelProperty(value = "价内折扣税额")
    @PositiveOrZero(message = "价内折扣税额不能为负数")
    private BigDecimal innerDiscountTax;

    @ApiModelProperty(value = "价内折扣含税金额")
    @PositiveOrZero(message = "价内折扣含税金额不能为负数")
    private BigDecimal innerDiscountWithTax;

    @ApiModelProperty(value = "价外折扣不含税金额")
    @PositiveOrZero(message = "价外折扣不含税金额不能为负数")
    private BigDecimal outerDiscountWithoutTax;

    @ApiModelProperty(value = "价外折扣税额")
    @PositiveOrZero(message = "价外折扣税额不能为负数")
    private BigDecimal outerDiscountTax;

    @ApiModelProperty(value = "价外折扣含税金额")
    @PositiveOrZero(message = "价外折扣含税金额不能为负数")
    private BigDecimal outerDiscountWithTax;
}
