package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel
@Data
public class OrderInvoiceInfo {

    @ApiModelProperty(value = "订单主信息", required = true)
    @NotNull(message = "订单主信息不能为空")
    @Valid
    private OrderMain orderMain;

    @ApiModelProperty(value = "订单明细信息", required = true)
    @NotEmpty(message = "订单明细信息不能为空")
    @Valid
    private List<OrderItem> orderItems;

    @ApiModelProperty(value = "订单发票关系信息")
    @Valid
    private List<OrderInvoiceRelation> orderInvoiceRelations;
}
