package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@ApiModel
@Data
public class OrderInvoiceRelation {

    @ApiModelProperty(value = "订单明细id", required = true)
    @NotNull(message = "orderItemId不能为空")
    private Long orderItemId;

    @ApiModelProperty(value = "发票号码", required = true)
    @NotEmpty(message = "发票号码不能为空")
    private String invoiceNo;

    @ApiModelProperty(value = "发票代码", required = true)
    @NotEmpty(message = "发票代码不能为空")
    private String invoiceCode;

    @ApiModelProperty(value = "发票明细行号", required = true)
    @NotNull(message = "发票明细行号")
    private Integer invoiceItemIndex;

    @ApiModelProperty(value = "订单明细开具信息，红票的开具信息为负数", required = true)
    @NotNull(message = "订单明细开具信息不能为空")
    @Valid
    private OrderItemMakeOutInfo makeOutInfo;
}
