package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@ApiModel
@Data
public class OrderItemMakeOutInfo {

    @ApiModelProperty(value = "已开具不含税金额", required = true)
    @NotNull(message = "已开具不含税金额不能为空")
    private BigDecimal makeOutAmountWithoutTax;

    @ApiModelProperty(value = "已开具扣除额", required = true)
    @NotNull(message = "已开具扣除额不能为空")
    private BigDecimal makeOutTaxDeduction;

    @ApiModelProperty(value = "已开具税额", required = true)
    @NotNull(message = "已开具税额不能为空")
    private BigDecimal makeOutTaxAmount;

    @ApiModelProperty(value = "已开具含税金额", required = true)
    @NotNull(message = "已开具含税金额不能为空")
    private BigDecimal makeOutAmountWithTax;

    @ApiModelProperty(value = "已开具价内不含税金额", required = true)
    @NotNull(message = "已开具价内不含税金额不能为空")
    private BigDecimal makeOutInnerDiscountWithoutTax;

    @ApiModelProperty(value = "已开具价内税额", required = true)
    @NotNull(message = "已开具价内税额不能为空")
    private BigDecimal makeOutInnerDiscountTax;

    @ApiModelProperty(value = "已开具价内含税金额", required = true)
    @NotNull(message = "已开具价内含税金额不能为空")
    private BigDecimal makeOutInnerDiscountWithTax;

    @ApiModelProperty(value = "已开具价外不含税金额", required = true)
    @NotNull(message = "已开具价外不含税金额不能为空")
    private BigDecimal makeOutOuterDiscountWithoutTax;

    @ApiModelProperty(value = "已开具价外税额", required = true)
    @NotNull(message = "已开具价外税额不能为空")
    private BigDecimal makeOutOuterDiscountTax;

    @ApiModelProperty(value = "已开具价外含税金额", required = true)
    @NotNull(message = "已开具价外含税金额不能为空")
    private BigDecimal makeOutOuterDiscountWithTax;
}
