package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.*;
import java.math.BigDecimal;

@ApiModel
@Data
public class OrderMain {

    @ApiModelProperty(value = "主订单号")
    @Length(max = 50)
    private String orderNo;

    @ApiModelProperty(value = "erp订单号")
    @Length(max = 50)
    private String erpNo;

    @ApiModelProperty(value = "手工生成订单号")
    @Length(max = 50)
    private String manuallyCreatedNo;

    @ApiModelProperty(value = "自动生成订单号")
    @Length(max = 50)
    private String autoCreateNo;

    @ApiModelProperty(value = "门店号", required = true)
    @NotBlank(message = "门店号不能为空")
    @Length(max = 50)
    private String storeNumber;

    @ApiModelProperty(value = "公司组织id", required = true)
    @NotNull(message = "公司组织id不能为空")
    private Long orgId;

    @ApiModelProperty(value = "不含税金额")
    @Positive(message = "不含税金额必须大于零")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额")
    @PositiveOrZero(message = "税额不能为负")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额", required = true)
    @NotNull(message = "含税金额不能为空")
    @Positive(message = "不含税金额必须大于零")
    private BigDecimal amountWithTax;


    @ApiModelProperty(value = "折扣不含税金额")
    @PositiveOrZero(message = "折扣不含税金额不能为负")
    private BigDecimal discountAmountWithoutTax;

    @ApiModelProperty(value = "折扣税额")
    @PositiveOrZero(message = "折扣税额不能为负")
    private BigDecimal discountTaxAmount;

    @ApiModelProperty(value = "折扣含税金额")
    @PositiveOrZero(message = "折扣含税金额不能为负")
    private BigDecimal discountAmountWithTax;

    @ApiModelProperty(value = "订单备注")
    @Length(max = 250)
    private String remark;

    @ApiModelProperty(value = "订单生成时间时间戳", required = true)
    @NotNull(message = "订单生成时间时间戳不能为空")
    @Min(value = 1514736000000L, message = "不支持的订单创建时间")
    private Long orderPostTime;

    @ApiModelProperty(value = "最大分摊金额")
    private BigDecimal maxManualSplitDiscount;

    @ApiModelProperty(value = "代表同一业务的订单id")
    private Long relatedOrderId;
}
