package com.xforceplus.tower.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiModel
@Data
public class UpdateOrder {

    @ApiModelProperty(value = "主订单号")
    @Length(max = 50)
    private String orderNo;

    @ApiModelProperty(value = "erp订单号")
    @Length(max = 50)
    private String erpNo;

    @ApiModelProperty(value = "手工生成订单号")
    @Length(max = 50)
    private String manuallyCreatedNo;

    @ApiModelProperty(value = "自动生成订单号")
    @Length(max = 50)
    private String autoCreateNo;

    @ApiModelProperty(value = "不含税金额")
    @Positive(message = "不含税金额必须大于零")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额")
    @PositiveOrZero(message = "税额不能为负")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额")
    @Positive(message = "不含税金额必须大于零")
    private BigDecimal amountWithTax;


    @ApiModelProperty(value = "折扣不含税金额，没有折扣为零")
    @PositiveOrZero(message = "折扣不含税金额不能为负")
    private BigDecimal discountAmountWithoutTax;

    @ApiModelProperty(value = "折扣税额，没有折扣为零")
    @PositiveOrZero(message = "折扣税额不能为负")
    private BigDecimal discountTaxAmount;

    @ApiModelProperty(value = "折扣含税金额，没有折扣为零")
    @PositiveOrZero(message = "折扣含税金额不能为负")
    private BigDecimal discountAmountWithTax;

    @ApiModelProperty(value = "订单备注")
    @Length(max = 250)
    private String remark;

    @ApiModelProperty(value = "订单明细信息")
    @Valid
    List<UpdateOrderItem> orderItems = new ArrayList<>();


}
