package com.xforceplus.tower.order.vo;

import com.xforceplus.tower.order.constant.ItemStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;

@ApiModel
@Data
public class UpdateOrderItem {

    @ApiModelProperty(value = "中台订单明细id")
    @NotNull(message = "明细id不能为空")
    private Long id;

    @ApiModelProperty(value = "明细名称")
    @Length(max = 120)
    private String itemName;

    @ApiModelProperty(value = "规格")
    @Length(max = 50)
    private String itemSpec;

    @ApiModelProperty(value = "数量")
    private BigDecimal quantity;

    @ApiModelProperty(value = "数量单位")
    @Length(max = 30)
    private String quantityUnit;

    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "不含税金额")
    @PositiveOrZero(message = "不含税金额不能为负数")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "扣除额")
    @PositiveOrZero(message = "扣除额不能为负数")
    private BigDecimal taxDeduction;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    @PositiveOrZero(message = "税额不能为负数")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额")
    @PositiveOrZero(message = "含税金额不能为负数")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "商品编码")
    @Length(max = 120)
    private String itemCode;

    @ApiModelProperty(value = "商品条码")
    @Length(max = 120)
    private String barCode;

    @ApiModelProperty(value = "折扣金额信息")
    @Valid
    private DiscountInfo discountAmountInfo;

    @ApiModelProperty(value = "税收优惠信息")
    private TaxPreInfo taxPreInfo;

    @ApiModelProperty(value = "扩展信息")
    private Object extInfo;

    @ApiModelProperty(value = "明细状态, 0 = 已退货，1= 正常")
    private ItemStatus itemStatus;

    @ApiModelProperty(value = "税收分类编码")
    private String goodsTaxNo;
}
