/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.order.api;

import com.xforceplus.tower.order.vo.AddOrderItem;
import com.xforceplus.tower.order.vo.BaseResponse;
import com.xforceplus.tower.order.vo.DeleteOrderItem;
import com.xforceplus.tower.order.vo.Order;
import com.xforceplus.tower.order.vo.OrderIdsData;
import com.xforceplus.tower.order.vo.QueryOrderResponse;
import com.xforceplus.tower.order.vo.UpdateOrder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api
@Validated
public interface OrderApi {
    @ApiOperation(value="\u65b0\u589e\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"/{tenantId}/order/v1/orders"}, produces={"application/json"}, method={RequestMethod.POST})
    public BaseResponse<OrderIdsData> createOrder(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355\u4fe1\u606f") @Valid @NotNull @RequestBody Order var3);

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}"}, produces={"application/json"}, method={RequestMethod.PATCH})
    public BaseResponse<String> modifyOrder(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3, @ApiParam(required=true, value="\u8ba2\u5355\u4fe1\u606f") @Valid @NotNull @RequestBody UpdateOrder var4);

    @ApiOperation(value="\u5bf9\u5df2\u5b58\u5728\u8ba2\u5355\u65b0\u589e\u8ba2\u5355\u660e\u7ec6")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}/items"}, produces={"application/json"}, method={RequestMethod.POST})
    public BaseResponse<OrderIdsData> addOrderItems(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3, @ApiParam(required=true, value="\u65b0\u589e\u660e\u7ec6\u4fe1\u606f") @RequestBody @Valid AddOrderItem var4);

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u4fe1\u606f,\u6574\u4e2a\u8986\u76d6")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}"}, produces={"application/json"}, method={RequestMethod.PUT})
    public BaseResponse<OrderIdsData> coverOrder(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3, @ApiParam(required=true, value="\u9700\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f") @RequestBody @Valid @NotNull Order var4);

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public BaseResponse<QueryOrderResponse> queryOrder(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3, @ApiParam(value="\u8ba2\u5355\u5173\u8054\u4fe1\u606f", allowableValues="invoice,") @RequestParam(required=false) String var4);

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u65b9\u8ba2\u5355\u53f7\u67e5\u8be2\u8ba2\u5355")
    @RequestMapping(value={"/{tenantId}/order/v1/orders"}, produces={"application/json"}, method={RequestMethod.GET})
    public BaseResponse<QueryOrderResponse> queryOrderByOrderNo(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(value="\u8ba2\u5355\u751f\u6210\u65f6\u95f4,yyyy-MM-dd") @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var3, @ApiParam(value="\u8ba2\u5355\u53f7", required=true) @RequestParam @NotEmpty String var4, @ApiParam(value="\u8ba2\u5355\u5173\u8054\u4fe1\u606f", allowableValues="invoice") @RequestParam(required=false) String var5);

    @ApiOperation(value="\u5220\u9664\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public BaseResponse<String> deleteOrder(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3);

    @ApiOperation(value="\u5220\u9664\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/{tenantId}/order/v1/orders/{id}/items"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public BaseResponse<String> deleteOrderItem(@ApiParam(required=true, value="\u79df\u6237id") @PathVariable(value="tenantId") Long var1, @ApiParam(required=true, value="\u4ea7\u54c1\u7ebfid") @NotNull @RequestParam(value="appId") Long var2, @ApiParam(required=true, value="\u8ba2\u5355id") @PathVariable Long var3, @ApiParam(required=true, value="\u5220\u9664\u660e\u7ec6\u4fe1\u606f") @RequestBody @Valid DeleteOrderItem var4);
}

