package com.xforceplus.phoenix.split.api;

import com.xforceplus.phoenix.split.model.BaseResponse;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@Api(value = "pre_invoice")
public interface PreInvoiceGenerateApi {

    @ApiOperation(value = "发送拆票请求")
    @RequestMapping(value = "/{tenantId}/{appId}/invoice/v1/pre-invoices", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<String> sendSplitMsg(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") long tenantId,
                                      @ApiParam(required = true, value = "产品线id") @PathVariable("appId") long appId,
                                      @ApiParam(required = true, value = "单据规则信息") @RequestBody @Valid CreatePreInvoiceParam createPreInvoiceParam);

}
