package com.xforceplus.phoenix.split.model;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 单据明细信息
 */
@ApiModel
public class BillItem {

    @ApiModelProperty(value = "单据明细id", required = true)
    @NotNull(message = "单据明细id不能为空")
    private String salesbillItemId;

    @ApiModelProperty(value = "单据id", required = true)
    @NotNull(message = "单据id不能为空")
    private String salesbillId;

    @ApiModelProperty("明细号")
    private String salesbillItemNo;

    @ApiModelProperty("单据号")
    private String salesbillNo;

    private int origin;

    private String orderDetailNo;

    private String itemCode;

    private String itemName;

    private String itemShortName;

    private String itemSpec;

    @ApiModelProperty("单价, 如果是null, 需转换成零")
    @NotNull(message = "单价不能为空")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "价外折扣含税", required = true)
    @NotNull(message = "价外折扣含税不能为空")
    private BigDecimal outterDiscountWithTax;

    @ApiModelProperty(value = "价外折扣不含税", required = true)
    @NotNull(message = "价外折扣不含税不能为空")
    private BigDecimal outterDiscountWithoutTax;

    @ApiModelProperty(value = "价外折扣税额", required = true)
    @NotNull(message = "价外折扣税额不能为空")
    private BigDecimal outterDiscountTax;

    @ApiModelProperty(value = "价内折扣含税", required = true)
    @NotNull(message = "价内折扣含税不能为空")
    private BigDecimal innerDiscountWithTax;

    @ApiModelProperty(value = "价内折扣不含税", required = true)
    @NotNull(message = "价内折扣不含税不能为空")
    private BigDecimal innerDiscountWithoutTax;

    @ApiModelProperty(value = "价内折扣含税", required = true)
    @NotNull(message = "价内折扣含税不能为空")
    private BigDecimal innerDiscountTax;

    @ApiModelProperty(value = "价内预付卡折扣含税", required = true)
    @NotNull(message = "价内预付卡折扣含税不能为空")
    private BigDecimal innerPrepayAmountWithTax;

    @ApiModelProperty(value = "价内预付卡折扣不含税", required = true)
    @NotNull(message = "价内预付卡折扣不含税不能为空")
    private BigDecimal innerPrepayAmountWithoutTax;

    @ApiModelProperty(value = "价内预付卡折扣税额", required = true)
    @NotNull(message = "价内预付卡折扣税额不能为空")
    private BigDecimal innerPrepayAmountTax;

    @ApiModelProperty(value = "价外预付卡折扣含税", required = true)
    @NotNull(message = "价外预付卡折扣含税不能为空")
    private BigDecimal outterPrepayAmountWithTax;

    @ApiModelProperty(value = "价外预付卡折扣不含税", required = true)
    @NotNull(message = "价外预付卡折扣不含税不能为空")
    private BigDecimal outterPrepayAmountWithoutTax;

    @ApiModelProperty(value = "价外预付卡折扣税额", required = true)
    @NotNull(message = "价外预付卡折扣税额不能为空")
    private BigDecimal outterPrepayAmountTax;

    @ApiModelProperty("数量, 如果是null, 需转换成零")
    @NotNull(message = "数量不能为空")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    private String quantityUnit;

    @ApiModelProperty(value = "含税金额", required = true)
    @NotNull(message = "含税金额不能为空")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "不含税金额", required = true)
    @NotNull(message = "不含税金额不能为空")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    @NotNull(message = "税额不能为空")
    private BigDecimal taxAmount;


    private BigDecimal originalAmountWithoutTax;

    @ApiModelProperty(value = "税率", required = true)
    @NotNull(message = "税率不能为空")
    private BigDecimal taxRate;

    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPre;

    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPreCon;

    @ApiModelProperty(value = "零税率标识")
    private String zeroTax;

    @ApiModelProperty("税收分类编码")
    private String goodsTaxNo;



    @ApiModelProperty("大类")
    private String largeCategoryName;

    @ApiModelProperty("中类")
    private String medianCategoryName;

    @ApiModelProperty("小类")
    private String smallCategoryName;

    @ApiModelProperty("拆分code, 0=成品油, 1=非成品油")
    private String splitCode;

    @ApiModelProperty("分类码")
    private String itemTypeCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty(value = "扣除额", required = true)
    @NotNull(message = "扣除额不能为空")
    private BigDecimal deductions;

    @ApiModelProperty(value = "折扣不含税")
    private BigDecimal discountWithoutTax;

    @ApiModelProperty(value = "折扣税额")
    private BigDecimal discountTax;

    @ApiModelProperty(value = "折扣含税")
    private BigDecimal discountWithTax;

    @ApiModelProperty("是否是红字明细")
    private boolean redItem;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    private String ext6;

    private String ext7;

    private String ext8;

    private String ext9;

    private String ext10;

    private String ext11;

    private String ext12;

    private String ext13;

    private String ext14;

    private String ext15;

    private String ext16;

    private String ext17;

    private String ext18;

    private String ext19;

    private String ext20;

    @ApiModelProperty("编码版本号")
    private String goodsNoVer;


    private boolean splitItem;

    public String getSalesbillItemId() {
        return salesbillItemId;
    }

    public void setSalesbillItemId(String salesbillItemId) {
        this.salesbillItemId = salesbillItemId;
    }

    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    public String getSalesbillItemNo() {
        return salesbillItemNo;
    }

    public void setSalesbillItemNo(String salesbillItemNo) {
        this.salesbillItemNo = salesbillItemNo;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }


    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getOutterDiscountWithTax() {
        return outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    public BigDecimal getOutterDiscountWithoutTax() {
        return outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    public BigDecimal getOutterDiscountTax() {
        return outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    public BigDecimal getInnerDiscountWithTax() {
        return innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    public BigDecimal getInnerDiscountWithoutTax() {
        return innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    public BigDecimal getInnerDiscountTax() {
        return innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    public BigDecimal getInnerPrepayAmountWithTax() {
        return innerPrepayAmountWithTax;
    }

    public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
        this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    }

    public BigDecimal getInnerPrepayAmountWithoutTax() {
        return innerPrepayAmountWithoutTax;
    }

    public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
        this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    }

    public BigDecimal getInnerPrepayAmountTax() {
        return innerPrepayAmountTax;
    }

    public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
        this.innerPrepayAmountTax = innerPrepayAmountTax;
    }

    public BigDecimal getOutterPrepayAmountWithTax() {
        return outterPrepayAmountWithTax;
    }

    public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
        this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    }

    public BigDecimal getOutterPrepayAmountWithoutTax() {
        return outterPrepayAmountWithoutTax;
    }

    public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
        this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    }

    public BigDecimal getOutterPrepayAmountTax() {
        return outterPrepayAmountTax;
    }

    public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
        this.outterPrepayAmountTax = outterPrepayAmountTax;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public String getLargeCategoryName() {
        return largeCategoryName;
    }

    public void setLargeCategoryName(String largeCategoryName) {
        this.largeCategoryName = largeCategoryName;
    }

    public String getMedianCategoryName() {
        return medianCategoryName;
    }

    public void setMedianCategoryName(String medianCategoryName) {
        this.medianCategoryName = medianCategoryName;
    }

    public String getSmallCategoryName() {
        return smallCategoryName;
    }

    public void setSmallCategoryName(String smallCategoryName) {
        this.smallCategoryName = smallCategoryName;
    }

    public String getSplitCode() {
        return splitCode;
    }

    public void setSplitCode(String splitCode) {
        this.splitCode = splitCode;
    }

    public String getItemTypeCode() {
        return itemTypeCode;
    }

    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getDeductions() {
        return deductions;
    }

    public void setDeductions(BigDecimal deductions) {
        this.deductions = deductions;
    }

    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }


    public BigDecimal getOriginalAmountWithoutTax() {
        return originalAmountWithoutTax;
    }

    public void setOriginalAmountWithoutTax(BigDecimal originalAmountWithoutTax) {
        this.originalAmountWithoutTax = originalAmountWithoutTax;
    }

    public int getOrigin() {
        return origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public boolean isSplitItem() {
        return splitItem;
    }

    public void setSplitItem(boolean splitItem) {
        this.splitItem = splitItem;
    }

    public String getOrderDetailNo() {
        return orderDetailNo;
    }

    public void setOrderDetailNo(String orderDetailNo) {
        this.orderDetailNo = orderDetailNo;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemShortName() {
        return itemShortName;
    }

    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    public boolean isRedItem() {
        return redItem;
    }

    public void setRedItem(boolean redItem) {
        this.redItem = redItem;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
