package com.xforceplus.phoenix.split.config;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@ConfigurationProperties(prefix = "rule")
public class DataProcessPluginConfig implements InitializingBean {

    private Map<String, List<String>> pluginBeanNames;

    public Map<String, List<String>> getPluginBeanNames() {
        return pluginBeanNames;
    }

    public void setPluginBeanNames(Map<String, List<String>> pluginBeanNames) {
        this.pluginBeanNames = pluginBeanNames;
    }

    public List<String> getBeanNamesByRuleCode(String ruleCode) {
        return pluginBeanNames.get(ruleCode);
    }

    @Override
    public void afterPropertiesSet() {
        if (pluginBeanNames == null) {
            pluginBeanNames = new HashMap<>(4);
        }
        List<String> plugins = new ArrayList<>();
        plugins.add("fieldProcessPlugin");
        plugins.add("groupItemByZeroTaxPlugin");
        plugins.add("groupItemByRedAndBluePlugin");
        plugins.add("groupItemBySplitCodePlugin");
        plugins.add("groupItemBySplitFieldPlugin");
        plugins.add("redBillItemProcessPlugin");
        plugins.add("splitBillItemPlugin");
        plugins.add("billItemDiscountAmountProcessPlugin");
        plugins.add("invoiceLimitProcessPlugin");
        pluginBeanNames.put("default", plugins);
    }
}
