package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;

/**
 * 项目名称:
 * 模块名称:
 * 说明:     发票明细顺序
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/1/31 11:08
 */
public enum InvoiceItemOrder {

    /**
     * 按照明细顺序开票
     */
    ITEM_NO_ORDER("0"),
    /**
     * 最少发票张数
     */
    MINIMUM_INVOICES("1");


    private final String orderType;



    InvoiceItemOrder(String orderType){
        this.orderType = orderType;
    }

    public String value(){
        return this.orderType;
    }
    public static InvoiceItemOrder fromValue(String value){
        return Arrays.stream(InvoiceItemOrder.values())
                .filter(s -> s.value().equals(value))
                .findAny()
                .orElseThrow(() -> new RuntimeException("错误的类型"));
    }
}
