package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.constant.ProductOil;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 预制发票生成接口
 */
public interface PreInvoiceGenerateService {


    /**
     * 备注size限制
     */
    int DEFAULT_SIZE = 168;
    /**
     * 电票-备注size限制
     */
    int ELECTRONIC_SIZE = 130;

    String TAX_CODE_SHORT_NAME_JOINER_PREFIX = "*";

    String TAX_CODE_SHORT_NAME_JOINER_SUFFIX = "*";

    String LIST_GOODS_NAME = "(详见销货清单)";

    String DEDUCTION_REMARK = "差额征税:{}";
    String RED_SPECIAL_REMARK = "开具红字增值税专用发票信息表编号{}";
    String RED_NORMAL_REMARK = "对应正数发票";
    String RED_NORMAL_REMARK_CODE = "代码:{}";
    String RED_NORMAL_REMARK_NO = "号码:{}";
    Set<String> HBBM_SET = Arrays.stream(ProductOil.values()).map(ProductOil::getHBBM).collect(Collectors.toSet());

    /**
     * 创建预制发票
     *
     * @param billInfo 单据信息
     * @param rule     规则
     * @return 预制发票
     */
    List<SplitPreInvoiceInfo> createPreInvoice(BillInfo billInfo, SplitRule rule);











}
