package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_DOWN;
import static java.math.BigDecimal.ROUND_HALF_UP;

@Service
public class BillItemDiscountAmountProcessPlugin implements DataProcessPlugin {

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        itemGroups.forEach(itemGroup -> {
            List<BillItem> billItems = itemGroup.getBillItems();
            Map<String, List<BillItem>> groupIdBillItems = billItems.stream()
                    .filter(BillItem::isSplitItem)
                    .collect(Collectors.groupingBy(BillItem::getSalesbillItemId));

            groupIdBillItems.forEach((billItemId, billItems1) -> processDiscountAmount(billItems1));
        });


        return itemGroups;
    }

    private void processDiscountAmount(List<BillItem> billItems) {
        BillItem lastBillItem = billItems.get(billItems.size() - 1);

        //未拆分之前的不含价内折扣金额
        BigDecimal amountWithoutTaxAndDiscount = lastBillItem.getOriginalAmountWithoutTax()
                .subtract(lastBillItem.getInnerDiscountWithoutTax())
                .subtract(lastBillItem.getInnerPrepayAmountWithoutTax());

        //未拆分之前的价外折扣金额
        BigDecimal outterDiscountAmount = lastBillItem.getOutterDiscountWithoutTax()
                .add(lastBillItem.getOutterPrepayAmountWithoutTax());

        DiscountAmountInfo discountAmountInfo = new DiscountAmountInfo();

        BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO;

        for (int i = 0; i < billItems.size() - 1; i++) {
            BillItem billItem = billItems.get(i);

            BigDecimal rate = billItem.getAmountWithoutTax().divide(amountWithoutTaxAndDiscount, 10, ROUND_DOWN);
            if (billItem.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                innerDiscountWithoutTax = calculateAmountWithoutTax(rate, billItem.getInnerDiscountWithoutTax());
            }
            if (billItem.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                innerPrepayAmountWithoutTax = calculateAmountWithoutTax(rate, billItem.getInnerPrepayAmountWithoutTax());
            }
            if (outterDiscountAmount.compareTo(BigDecimal.ZERO) > 0) {
                rate = billItem.getOutterDiscountWithoutTax().divide(outterDiscountAmount, 10, ROUND_DOWN);
                outterDiscountWithoutTax = calculateAmountWithoutTax(rate, billItem.getDiscountWithoutTax());
                outterPrepayAmountWithoutTax = billItem.getDiscountWithoutTax().subtract(outterDiscountWithoutTax);
            }

            processItemDiscountAmount(discountAmountInfo, billItem,
                    innerDiscountWithoutTax,
                    innerPrepayAmountWithoutTax,
                    outterDiscountWithoutTax,
                    outterPrepayAmountWithoutTax);
        }

        lastBillItem.setInnerDiscountWithoutTax(lastBillItem.getInnerDiscountWithoutTax()
                .subtract(discountAmountInfo.getInnerDiscountWithoutTax()));
        lastBillItem.setInnerDiscountTax(lastBillItem.getInnerDiscountTax()
                .subtract(discountAmountInfo.getInnerDiscountTax()));
        lastBillItem.setInnerDiscountWithTax(lastBillItem.getInnerDiscountWithTax()
                .subtract(discountAmountInfo.getInnerDiscountWithTax()));

        lastBillItem.setInnerPrepayAmountWithoutTax(lastBillItem.getInnerPrepayAmountWithoutTax()
                .subtract(discountAmountInfo.getInnerPrepayAmountWithoutTax()));
        lastBillItem.setInnerPrepayAmountTax(lastBillItem.getInnerPrepayAmountTax()
                .subtract(discountAmountInfo.getInnerPrepayAmountTax()));
        lastBillItem.setInnerPrepayAmountWithTax(lastBillItem.getInnerPrepayAmountWithTax()
                .subtract(discountAmountInfo.getInnerPrepayAmountWithTax()));

        lastBillItem.setOutterDiscountWithoutTax(lastBillItem.getOutterDiscountWithoutTax()
                .subtract(discountAmountInfo.getOutterDiscountWithoutTax()));
        lastBillItem.setOutterDiscountTax(lastBillItem.getOutterDiscountTax()
                .subtract(discountAmountInfo.getOutterDiscountTax()));
        lastBillItem.setOutterDiscountWithTax(lastBillItem.getOutterDiscountWithTax()
                .subtract(discountAmountInfo.getOutterDiscountWithTax()));

        lastBillItem.setOutterPrepayAmountWithoutTax(lastBillItem.getOutterPrepayAmountWithoutTax()
                .subtract(discountAmountInfo.getOutterPrepayAmountWithoutTax()));
        lastBillItem.setOutterPrepayAmountTax(lastBillItem.getOutterPrepayAmountTax()
                .subtract(discountAmountInfo.getOutterPrepayAmountTax()));
        lastBillItem.setOutterPrepayAmountWithTax(lastBillItem.getOutterPrepayAmountWithTax()
                .subtract(discountAmountInfo.getOutterPrepayAmountWithTax()));

    }

    private void processItemDiscountAmount(DiscountAmountInfo discountAmountInfo,
                                           BillItem billItem,
                                           BigDecimal innerDiscountWithoutTax,
                                           BigDecimal innerPrepayAmountWithoutTax,
                                           BigDecimal outterDiscountWithoutTax,
                                           BigDecimal outterPrepayAmountWithoutTax) {
        BigDecimal rateTax = billItem.getTaxRate();
        BigDecimal innerDiscountTax = calculateTaxAmount(innerDiscountWithoutTax, rateTax);
        BigDecimal innerDiscountWithTax = calculateAmountWithTax(innerDiscountWithoutTax, innerDiscountTax);

        billItem.setInnerDiscountWithoutTax(innerDiscountWithoutTax);
        billItem.setInnerDiscountTax(innerDiscountTax);
        billItem.setInnerDiscountWithTax(innerDiscountWithTax);
        discountAmountInfo.setInnerDiscountWithoutTax(discountAmountInfo.getInnerDiscountWithoutTax().add(innerDiscountWithoutTax));
        discountAmountInfo.setInnerDiscountTax(discountAmountInfo.getInnerDiscountTax().add(innerDiscountTax));
        discountAmountInfo.setInnerDiscountWithTax(discountAmountInfo.getInnerDiscountWithTax().add(innerDiscountWithTax));

        BigDecimal innerPrepayAmountTax = calculateTaxAmount(innerPrepayAmountWithoutTax, rateTax);
        BigDecimal innerPrepayAmountWithTax = calculateAmountWithTax(innerPrepayAmountWithoutTax, innerPrepayAmountTax);

        billItem.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithoutTax);
        billItem.setInnerPrepayAmountTax(innerPrepayAmountTax);
        billItem.setInnerPrepayAmountWithTax(innerPrepayAmountWithTax);
        discountAmountInfo.setInnerPrepayAmountWithoutTax(discountAmountInfo.getInnerPrepayAmountWithoutTax().add(innerPrepayAmountWithoutTax));
        discountAmountInfo.setInnerPrepayAmountTax(discountAmountInfo.getInnerPrepayAmountTax().add(innerPrepayAmountTax));
        discountAmountInfo.setInnerPrepayAmountWithTax(discountAmountInfo.getInnerPrepayAmountWithTax().add(innerPrepayAmountWithTax));

        BigDecimal outterDiscountTax = calculateTaxAmount(outterDiscountWithoutTax, rateTax);
        BigDecimal outterDiscountWithTax = calculateAmountWithTax(outterDiscountWithoutTax, outterDiscountTax);

        BigDecimal outterPrepayAmountTax = calculateTaxAmount(outterPrepayAmountWithoutTax, rateTax);
        BigDecimal outterPrepayAmountWithTax = calculateAmountWithTax(outterPrepayAmountWithoutTax, outterPrepayAmountTax);

        billItem.setOutterDiscountWithoutTax(outterDiscountWithoutTax);
        billItem.setOutterDiscountTax(outterDiscountTax);
        billItem.setOutterDiscountWithTax(outterDiscountWithTax);
        discountAmountInfo.setOutterDiscountWithoutTax(discountAmountInfo.getOutterDiscountWithoutTax().add(outterDiscountWithoutTax));
        discountAmountInfo.setOutterDiscountTax(discountAmountInfo.getOutterDiscountTax().add(outterDiscountTax));
        discountAmountInfo.setOutterDiscountWithTax(discountAmountInfo.getOutterDiscountWithTax().add(outterDiscountWithTax));

        billItem.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithoutTax);
        billItem.setOutterPrepayAmountTax(outterPrepayAmountTax);
        billItem.setOutterPrepayAmountWithTax(outterPrepayAmountWithTax);
        discountAmountInfo.setOutterPrepayAmountWithoutTax(discountAmountInfo.getOutterPrepayAmountWithoutTax().add(outterPrepayAmountWithoutTax));
        discountAmountInfo.setOutterPrepayAmountTax(discountAmountInfo.getOutterPrepayAmountTax().add(outterPrepayAmountTax));
        discountAmountInfo.setOutterPrepayAmountWithTax(discountAmountInfo.getOutterPrepayAmountWithTax().add(outterPrepayAmountWithTax));
    }

    private BigDecimal calculateAmountWithTax(BigDecimal amountWithoutTax, BigDecimal amountTax) {
        return amountWithoutTax.add(amountTax);
    }

    private BigDecimal calculateTaxAmount(BigDecimal amountWithoutTax, BigDecimal rateTax) {
        return amountWithoutTax.multiply(rateTax).setScale(2, ROUND_HALF_UP);
    }

    private BigDecimal calculateAmountWithoutTax(BigDecimal rate, BigDecimal totalAmountWithoutTax) {
        return rate.multiply(totalAmountWithoutTax).setScale(2, ROUND_HALF_UP);
    }


    private class DiscountAmountInfo {
        private BigDecimal outterDiscountWithTax = BigDecimal.ZERO; // 价外折扣含税

        private BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO; // 价外折扣不含税

        private BigDecimal outterDiscountTax = BigDecimal.ZERO; // 价外折扣税额

        private BigDecimal innerDiscountWithTax = BigDecimal.ZERO; // 价内折扣含税

        private BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO; // 价内折扣不含税

        private BigDecimal innerDiscountTax = BigDecimal.ZERO; // 价内折扣税额

        private BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO; // 价外预付卡含税

        private BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO; // 价外预付卡不含税

        private BigDecimal outterPrepayAmountTax = BigDecimal.ZERO; // 价外预付卡税额

        private BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO; // 价内预付卡含税

        private BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO; // 价内预付卡不含税

        private BigDecimal innerPrepayAmountTax = BigDecimal.ZERO; // 价内预付卡税额

        public BigDecimal getOutterDiscountWithTax() {
            return outterDiscountWithTax;
        }

        public BigDecimal getOutterDiscountWithoutTax() {
            return outterDiscountWithoutTax;
        }

        public BigDecimal getOutterDiscountTax() {
            return outterDiscountTax;
        }

        public BigDecimal getInnerDiscountWithTax() {
            return innerDiscountWithTax;
        }

        public BigDecimal getInnerDiscountWithoutTax() {
            return innerDiscountWithoutTax;
        }

        public BigDecimal getInnerDiscountTax() {
            return innerDiscountTax;
        }

        public BigDecimal getOutterPrepayAmountWithTax() {
            return outterPrepayAmountWithTax;
        }

        public BigDecimal getOutterPrepayAmountWithoutTax() {
            return outterPrepayAmountWithoutTax;
        }

        public BigDecimal getOutterPrepayAmountTax() {
            return outterPrepayAmountTax;
        }

        public BigDecimal getInnerPrepayAmountWithTax() {
            return innerPrepayAmountWithTax;
        }

        public BigDecimal getInnerPrepayAmountWithoutTax() {
            return innerPrepayAmountWithoutTax;
        }

        public BigDecimal getInnerPrepayAmountTax() {
            return innerPrepayAmountTax;
        }

        public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
            this.outterDiscountWithTax = outterDiscountWithTax;
        }

        public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
            this.outterDiscountWithoutTax = outterDiscountWithoutTax;
        }

        public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
            this.outterDiscountTax = outterDiscountTax;
        }

        public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
            this.innerDiscountWithTax = innerDiscountWithTax;
        }

        public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
            this.innerDiscountWithoutTax = innerDiscountWithoutTax;
        }

        public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
            this.innerDiscountTax = innerDiscountTax;
        }

        public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
            this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
        }

        public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
            this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
        }

        public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
            this.outterPrepayAmountTax = outterPrepayAmountTax;
        }

        public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
            this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
        }

        public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
            this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
        }

        public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
            this.innerPrepayAmountTax = innerPrepayAmountTax;
        }
    }
}
