package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.stereotype.Service;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

/**
 * 立邦拆票根据拆票字段分组实现，记录哪些组是由同一个组派生出来
 */
@Service
public class LBGroupItemBySplitFieldPlugin extends GroupItemBySplitFieldPlugin {


    @Override
    protected List<ItemGroup> groupBillItem(List<ItemGroup> itemGroups, SplitRule rule) {
        List<ItemGroup> result = new LinkedList<>();
        for (ItemGroup itemGroup : itemGroups) {
            String uuid = UUID.randomUUID().toString();

            List<BillItem> billItems = itemGroup.getBillItems();

            ListMultimap<String, BillItem> group = MultimapBuilder.linkedHashKeys().linkedListValues().build();
            billItems.forEach(billItem -> {
                String key = generateKey(billItem, rule);
                group.put(key, billItem);
            });


            group.keySet().forEach(key -> {
                ItemGroup newItemGroup = new ItemGroup(uuid);
                newItemGroup.setBillItems(group.get(key));
                result.add(newItemGroup);
            });
        }
        return result;
    }
}
